package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.LabelsCallback;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;


public abstract class EIFormsPanel extends Composite implements ClientRepositoryToolsManager.SessionListener {
	
	protected VerticalPanel formPanel= new VerticalPanel();
	
	protected EIInstance eiInstance;
	
	abstract void drawDataProperty(EIEntity propertyEntity, Set<String> propertyValues);
	
	abstract void drawObjectProperty(EIEntity propertyEntity, Set<EIURI> propertyValues);
	
	abstract void drawNonOntologyLiteralProperty(EIEntity propertyEntity, Set<String> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel);
	
	abstract void drawNonOntologyResourceProperty(EIEntity propertyEntity, Set<EIURI> propertyValues, Map<EIEntity, String> labelMap, VerticalPanel nonOntologyPanel);
	
	abstract protected void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties);
	
	abstract Collection<EIEntity> getDataTypeEntities();
	
	abstract Collection<EIEntity> getObjectTypeEntities();
	
	abstract Collection<EIEntity> getNonOntologyLiteralPropEntities();
	
	abstract Collection<EIEntity> getNonOntologyResourcePropEntities();
	
	protected final EIEntity propertyName = EIEntity.create("", "Resource Name");
	
	protected final EIEntity propertyType = EIEntity.create("","Type");
	
	protected boolean shouldShowReadOnlyProperties;
	
	public EIFormsPanel(EIInstance instance) {
		initWidget(formPanel);
		this.eiInstance = instance;
	}

	protected void finishSetup() {
		constructForm();
		formPanel.setStyleName("formPanel");
		formPanel.setSpacing(30);
		formPanel.setHeight("50");
		ClientRepositoryToolsManager.INSTANCE.addSessionListener(this);
	}
	
	public EIInstance getInstance() {
		return eiInstance;
	}
	
	protected void constructForm() {
		 Map<EIEntity, Set<String>> dataTypeProperties = eiInstance.getDatatypeProperties();
		 Map<EIEntity, Set<EIURI>> objectTypeProperties = eiInstance.getObjectProperties();
		 final Map<EIEntity, Set<String>> nonOntologyLiteralProperties = eiInstance.getNonOntologyLiteralProperties();
		 final Map<EIEntity, Set<EIURI>> nonOntologyResourceProperties = eiInstance.getNonOntologyResourceProperties();
		 
		 drawDataProperty(propertyName, makeSetFromSingle(eiInstance.getInstanceLabel()));
		 
		 drawObjectProperty(propertyType, new HashSet<EIURI>(Arrays.asList(new EIURI[]{eiInstance.getInstanceType().getURI()})));
		 
		 for(EIEntity propEntity:getDataTypeEntities()) {
			 drawDataProperty(propEntity, dataTypeProperties.get(propEntity));
		 }
		 
		 for(EIEntity propEntity:getObjectTypeEntities()) {
			 drawObjectProperty(propEntity, objectTypeProperties.get(propEntity));
		 }
		
		 drawExtraFields(nonOntologyLiteralProperties);
		 
		 final DisclosurePanel nonOntologyPanel = new DisclosurePanel("Information for data curators");
		 
		 final Map<EIEntity, Set<String>> nonOntLiteralList = eiInstance.getNonOntologyLiteralProperties();
		 final Map<EIEntity, Set<EIURI>> nonOntResourceList = eiInstance.getNonOntologyResourceProperties();
		 final List<EIEntity> entityList = new ArrayList<EIEntity>();
		 entityList.addAll(eiInstance.getReadOnlyLiteralProperties().keySet());
		 entityList.addAll(eiInstance.getReadOnlyResourceProperties().keySet());
		 entityList.addAll(nonOntResourceList.keySet());
		 entityList.addAll(nonOntLiteralList.keySet());
		
		 
		 final VerticalPanel innerPanel = new VerticalPanel();
		 ClientRepositoryToolsManager.INSTANCE.retrieveLabels(entityList, new LabelsCallback() {
			@Override
			public void onSuccess(Map<EIEntity, String> labelMap) {
				createNonOntologyPanel(nonOntologyLiteralProperties, nonOntologyResourceProperties, labelMap, innerPanel);
			}
		 });
		 
		nonOntologyPanel.add(innerPanel);
		formPanel.add(nonOntologyPanel); 
			
	 }

	private HashSet<String> makeSetFromSingle(String value) {
		return new HashSet<String>(Arrays.asList(new String[]{value}));
	}
	
	private HashSet<EIURI> makeSetFromSingleURI(EIURI value) {
		return new HashSet<EIURI>(Arrays.asList(new EIURI[]{value}));
	}

	 protected void createNonOntologyPanel(Map<EIEntity, Set<String>> nonOntologyLiteralProperties,
				Map<EIEntity, Set<EIURI>> nonOntologyResourceProperties, Map<EIEntity, String> labelMap, VerticalPanel innerPanel) {
		 
		 final VerticalPanel metaPanel = new VerticalPanel();
		 final VerticalPanel otherPanel = new VerticalPanel();
		 designPanel(metaPanel,"Metadata properties:");
		 designPanel(otherPanel,"Other properties:");
		 
		 LabelValuesWidget eagleIUniqueId = new LabelValuesWidget("eagle-i unique ID");
		 Anchor id = new Anchor(eiInstance.getInstanceURI().toString(), eiInstance.getInstanceURI().toString(), "_blank");
		 eagleIUniqueId.add(id);
		 innerPanel.add(eagleIUniqueId);
		 if (shouldShowReadOnlyProperties) {
			 innerPanel.add(metaPanel);
			 innerPanel.add(otherPanel);
			 
			 Map<EIEntity, String> readOnlyLiterals = eiInstance.getReadOnlyLiteralProperties();
			 Map<EIEntity, EIURI> readOnlyResources = eiInstance.getReadOnlyResourceProperties();
		 
			 drawReadOnlyProperties(labelMap, metaPanel, readOnlyLiterals, readOnlyResources);
		 }
		 
		 VerticalPanel panelToUse = shouldShowReadOnlyProperties ? otherPanel : innerPanel;
		 for(EIEntity propEntity:nonOntologyLiteralProperties.keySet()) {
			 drawNonOntologyLiteralProperty(propEntity, nonOntologyLiteralProperties.get(propEntity), labelMap, panelToUse);
		 }
		 
		 for(EIEntity propEntity:nonOntologyResourceProperties.keySet()) {
			 drawNonOntologyResourceProperty(propEntity, nonOntologyResourceProperties.get(propEntity), labelMap, panelToUse);
		 }
		 
	}

	private void drawReadOnlyProperties(Map<EIEntity, String> labelMap,
			final VerticalPanel metaPanel,
			Map<EIEntity, String> readOnlyLiterals,
			Map<EIEntity, EIURI> readOnlyResources) {
		for (EIEntity propEntity: readOnlyLiterals.keySet()) {
			 drawNonOntologyLiteralProperty(propEntity, makeSetFromSingle(readOnlyLiterals.get(propEntity)), labelMap, metaPanel);			 
		 }
		 
		 for (EIEntity propEntity: readOnlyResources.keySet()) {
			 drawNonOntologyResourceProperty(propEntity, makeSetFromSingleURI(readOnlyResources.get(propEntity)), labelMap, metaPanel);			 
		 }
	}

	private void designPanel(final VerticalPanel panel, String header) {
		 panel.setStyleName("formPanel");
		 
		 Label propHeader = new Label(header);
		 propHeader.setStyleName("nonOntologyPropertyLabel");
		 panel.add(propHeader);
	}
	
	
}
