package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EISuperClassCallback;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.PropertyCallback;
import org.eaglei.datatools.model.DataToolsModelConfig;
import org.eaglei.datatools.model.DataToolsOntConstants;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.VerticalPanel;

public class EditFormsPanel extends EIFormsPanel{
	
	private EIClass eiClass;
	
	private final List<EIEntity>  dataPropEntityList = new ArrayList<EIEntity>();
	
	private final List<EIEntity> booleanPropEntityList = new ArrayList<EIEntity>();
	
	private final List<EIEntity>  objPropEntityList = new ArrayList<EIEntity>();
	
	private final Map<EIEntity, List<EIClass>> objectProperties = new HashMap<EIEntity, List<EIClass>>();
	
	private final EIURI labUri;
	
	private final boolean isNew;
	
	public static final String EI_LAB = "http://purl.obolibrary.org/obo/ERO_0000001";
	public static final String EI_CORE_LAB = "http://purl.obolibrary.org/obo/ERO_0000002";
	
	public static EditFormsPanel createEditForm(EIInstance instance, EIClass eiClass, EIURI labUri) {
		return new EditFormsPanel(instance, eiClass, labUri, false);
	}
	
	public static EditFormsPanel createNewForm(EIInstance instance, EIClass eiClass, EIURI labUri) {
		return new EditFormsPanel(instance, eiClass, labUri, true);
	}
	
	private EditFormsPanel(EIInstance instance, EIClass eiClass, EIURI labUri, boolean isNew) {
		super(instance);
		shouldShowReadOnlyProperties = false;
		this.eiClass = eiClass;
		initializePropertyLists(); // call finishSetup inside the callback--don't do anything until we have properties
		this.isNew = isNew;
		this.labUri = (labUri == null  || labUri.toString().equals("")) ? null : labUri;
		Log.info("have lab? " + hasLabUri());
	}
		
	public boolean isNewForm() {
		return isNew;
	}

	@Override
	void drawDataProperty(EIEntity propertyEntity, Set<String> propertyValues) {
		if (propertyEntity == propertyName) {
			formPanel.add(TextWidget.makeLabelTextWidget(eiInstance, propertyEntity, propertyValues.iterator().next()));
		} 
		else if (propertyValues == null || propertyValues.size() == 0) 
		{
			if(booleanPropEntityList.contains(propertyEntity)) {
				formPanel.add(WidgetUtils.createRadioButon(eiInstance, propertyEntity, null));
			} else {
				formPanel.add(new EditWidgetCollection(eiInstance, propertyEntity, TextWidget.makeDatatypeTextWidget(eiInstance, propertyEntity, null)));
			}
		}
		else {
			EditWidgetCollection fields = new EditWidgetCollection(eiInstance, propertyEntity);
			for(String value:propertyValues) {
				if(booleanPropEntityList.contains(propertyEntity)) {
					fields.addWithoutModifiers(WidgetUtils.createRadioButon(eiInstance, propertyEntity, value));
				} else {
					fields.addWidget(TextWidget.makeDatatypeTextWidget(eiInstance, propertyEntity, value));
				}
			}
			formPanel.add(fields);
		}
		
	}

	@Override
	void drawNonOntologyLiteralProperty(EIEntity propertyEntity,Set<String> propertyValues, Map<EIEntity, String> labelMap,	VerticalPanel nonOntologyPanel) {
		if(!propertyEntity.getURI().toString().equals(WorkFlowConstants.COMMENTS) && !propertyEntity.getURI().toString().equals(WorkFlowConstants.CURATOR_NOTE)) {
			EditWidgetCollection fields = new EditWidgetCollection(eiInstance, propertyEntity);
			nonOntologyPanel.add(fields); // TODO: does this need to be after?
			for(String value:propertyValues) {
				fields.addWidget(TextWidget.makeNonOntologyTextWidget(eiInstance, propertyEntity, value));
			}
		}
		
	}

	@Override
	void drawNonOntologyResourceProperty(EIEntity propertyEntity,Set<EIURI> propertyValues, Map<EIEntity, String> labelMap,
				VerticalPanel nonOntologyPanel) {
		EditWidgetCollection fields = new EditWidgetCollection(eiInstance, propertyEntity);
		nonOntologyPanel.add(fields);
		for(EIURI value:propertyValues) {
			fields.addWidget(TextWidget.makeNonOntologyTextWidget(eiInstance, propertyEntity, value));
		}
		
	}

	@Override
	void drawObjectProperty(EIEntity propertyEntity, Set<EIURI> propertyValues) {
		
		if(propertyEntity.getLabel().equals("Type")) { // Type does not have a range
			drawTypeProperty();
		} else if(objectProperties.get(propertyEntity) != null && objectProperties.get(propertyEntity).size() > 0){
			EditWidgetCollection fields = new EditWidgetCollection(eiInstance, propertyEntity);
			formPanel.add(fields);
			
			if(objectProperties.get(propertyEntity).size()==1) { //Single range
				drawSingleObjectProperty(propertyEntity, propertyValues, fields);
			} else { // Multiple ranges
				Log.info(propertyEntity + " is a multi-range item  with " + (propertyValues == null ? "<null>" : propertyValues.size()) + "entries" );
				if (propertyValues == null || propertyValues.size() == 0) {
					createWidgetForMultiRanges(propertyEntity, "", fields);
				}
				else {
					for(EIURI selectedUri:propertyValues) {
						createWidgetForMultiRanges(propertyEntity, selectedUri.toString(), fields);
					}
				}
			}
		}
	}

	private void drawSingleObjectProperty(EIEntity propertyEntity, Set<EIURI> propertyValues, EditWidgetCollection fields) {
		EIClass range = objectProperties.get(propertyEntity).iterator().next();
		// TODO: maybe skip the hasLabUri -- should this just be disabled?  
		if (hasLabUri() && isLabProperty(range)) {
			Log.info("making disabled widget for lab uri '" + labUri + "' property " + range.getEntity().getLabel());
			eiInstance.addObjectProperty(propertyEntity, labUri);
			createWidgetForRange(propertyEntity, range, labUri.toString(), fields, true);					
		}
		else if (propertyValues == null || propertyValues.size() == 0) { // new 
			if (isLabProperty(range))
				Log.info("drawing widget for lab prop " + range.getEntity().getLabel() + " without treating it as lab");
			createWidgetForRange(propertyEntity, range, "", fields, false);
		}
		else { // existing
			if (isLabProperty(range))
				Log.info("drawing multiple widgets for lab prop " + range.getEntity().getLabel() + " without treating it as lab");
			
			for(EIURI selectedUri:propertyValues) {
				createWidgetForRange(propertyEntity, range, selectedUri.toString(), fields, false);
			}
		}
	}

	private void drawTypeProperty() {
		final HorizontalPanel temp = new HorizontalPanel();
		formPanel.add(temp);
		ClientOntologyToolsManager.INSTANCE.getRootSuperClass(eiInstance.getInstanceClass(), new EISuperClassCallback() {				
			@Override
			public void onSuccess(final EIClass superclass) {
				TypeWidget typeWidget = new TypeWidget(eiInstance, null, superclass, eiInstance.getInstanceClass(), new TypeWidget.TypeChangeHandler() {
					@Override
					public void onTypeChange() {
						Log.info("redrawing; type changed to " + eiInstance.getInstanceClass());
						formPanel.clear();
						eiClass = eiInstance.getInstanceClass();
						initializePropertyLists(); // re-gets lists, re-draws form.  Also adds as a session listener *again*
					}			
				});
				temp.add(typeWidget);
			}
		});
	}

	private void createWidgetForMultiRanges(EIEntity propertyEntity, String selectedUri, final EditWidgetCollection fields) {
		Log.info("making multi-range widget with " + objectProperties.get(propertyEntity).size() + " ranges");
		ObjectWidget widget = new ObjectWidget(eiInstance, propertyEntity, objectProperties.get(propertyEntity), selectedUri);
		fields.addWidget(widget);
	}

	private void createWidgetForRange(final EIEntity propertyEntity, final EIClass range, String selectedUriString, final EditWidgetCollection fields, final boolean isLab) {
		if(range.isEagleIResource()) {				
			EIResourceWidget resourceWidget = new EIResourceWidget(eiInstance, propertyEntity, range, selectedUriString, true);
			fields.addWidget(resourceWidget, isLab);
			if (isLab) 
				resourceWidget.disable();
		} else {
			WidgetUtils.addTermWidgetToPanel(eiInstance, propertyEntity, range, selectedUriString, fields, true);		
		}
	}

	@Override
	public void onLogIn(String username, String userUri) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onLogOut() {
		// TODO Auto-generated method stub
		
	}

	@Override
	Collection<EIEntity> getDataTypeEntities() {
		return dataPropEntityList;
	}

	@Override
	Collection<EIEntity> getNonOntologyLiteralPropEntities() {
		return eiInstance.getNonOntologyLiteralProperties().keySet();
	}

	@Override
	Collection<EIEntity> getNonOntologyResourcePropEntities() {
		return eiInstance.getNonOntologyResourceProperties().keySet();
	}

	@Override
	Collection<EIEntity> getObjectTypeEntities() {
		return objPropEntityList;
	}
	
	@Override
	protected void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
		EIEntity comments = EIEntity.create(WorkFlowConstants.COMMENTS, WorkFlowConstants.COMMENTS_LABEL);
		EIEntity curatorComments = EIEntity.create(WorkFlowConstants.CURATOR_NOTE, WorkFlowConstants.CURATOR_LABEL);
		
		String commentValue = nonOntologyLiteralProperties.containsKey(comments) ? nonOntologyLiteralProperties.get(comments).iterator().next() : null;
		TextAreaWidget commentsArea = new TextAreaWidget(eiInstance, comments, commentValue);
		formPanel.add(commentsArea);
		
		String curatorValue = nonOntologyLiteralProperties.containsKey(curatorComments) ? nonOntologyLiteralProperties.get(curatorComments).iterator().next() : null;
		TextAreaWidget curatorArea = new TextAreaWidget(eiInstance, curatorComments, curatorValue);
		formPanel.add(curatorArea);
	}
	
	private void initializePropertyLists() {
		dataPropEntityList.clear();
		objPropEntityList.clear();
		objectProperties.clear();
		booleanPropEntityList.clear();
		
		ClientOntologyToolsManager.INSTANCE.getProperties(eiClass, new PropertyCallback() {
			@Override
			public void onSuccess(EIClass result) {
				for (EIProperty property : result.getProperties()) {
					if (property instanceof EIDatatypeProperty) {
						dataPropEntityList.add(property.getEntity());
						if (((EIDatatypeProperty) property).getTypeLabel().equals("boolean")) {
							booleanPropEntityList.add(property.getEntity());
						}
					}
					else if (property instanceof EIObjectProperty) {
						objPropEntityList.add(property.getEntity());
						objectProperties.put(property.getEntity(), ((EIObjectProperty) property).getRangeList());
					}
				} 
				finishSetup();
			}
		});
	}
	
	protected boolean isLabProperty(EIClass range) {
		EIEntity entity = range.getEntity();
		return (entity.getURI().toString().equals(EI_LAB) || entity.getURI().toString().equals("core laboratory"));
	}

	protected boolean hasLabUri() {
		return (labUri != null) && (! labUri.toString().equals(""));
	}

}
