package org.eaglei.datatools.client.ui;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.suggest.client.EntitySelectionListener;
import org.eaglei.suggest.client.SharedClassChooser;

public class TermWidget extends EditWidget{

	private EIClass range;
	private EIClass selectedClass; 
	private boolean shouldHaveLabel;
	
	private final EIEntity termRequestEntity = EIEntity.create("http://eagle-i.org/ont/datatools/1.0/has_term_request", "Term request");
	
	TermWidget(EIInstance eiInstance, EIEntity propertyEntity, EIClass range, EIClass selectedClass, boolean shouldShowLabel) {
		super(eiInstance, propertyEntity);
		this.range = range;
		this.selectedClass = selectedClass;
		shouldHaveLabel = shouldShowLabel;
		if (! shouldHaveLabel)
			widgetPanel.remove(label);
		setup();
	}

	private void setup() {
		SharedClassChooser<OntologyDropdown> classChooser = new SharedClassChooser<OntologyDropdown>(new OntologyDropdown());
		classChooser.setClass(range, false);
		classChooser.setTextBoxStyle("textSuggest");
		if (selectedClass != null) {
			classChooser.setSelectedEntity(selectedClass.getEntity());
		} 
		
		widgetPanel.add(classChooser);
		
		widgetPanel.add(TextWidget.makeNonOntologyTextWidget(eiInstance, termRequestEntity, ""));
		
		makeSelectionHandler(classChooser);
		
	}

	// overridden in subclass for type
	protected void makeSelectionHandler(SharedClassChooser<OntologyDropdown> classChooser) {
		classChooser.addSelectionListener(new EntitySelectionListener() {
			@Override
			public void onSelection(final EIEntity selectedEntity) {
				if(hasOldValue()) {
					eiInstance.replaceObjectPropertyValue(propertyEntity, EIURI.create(oldValue), selectedEntity.getURI());
				} else {
					eiInstance.addObjectProperty(propertyEntity, selectedEntity.getURI());
				}
				updateOldValue(selectedEntity.getURI());
				
			}
		});
	}
	
	@Override
	protected void removeValue() {
		if (hasOldValue())
			eiInstance.replaceObjectPropertyValue(propertyEntity, getOldEIURIValue(), null);
	}
	
	@Override
	public EditWidget duplicateBlank() {
		return new TermWidget(eiInstance, propertyEntity, range, null, false);
	}
}
