package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EIClassCallback;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.suggest.client.EntitySelectionListener;
import org.eaglei.suggest.client.SharedClassChooser;

public class TypeWidget extends TermWidget {

	private TypeChangeHandler typeChangeHandler;
	protected interface TypeChangeHandler {
		public void onTypeChange();
	}
	
	TypeWidget(EIInstance eiInstance, EIEntity propertyEntity, EIClass range, EIClass selectedClass, TypeChangeHandler typeChangeHandler) {
		super(eiInstance, propertyEntity, range, selectedClass, true);
		this.typeChangeHandler = typeChangeHandler;
		setShouldShowLabel(true);
	}
	
	@Override
	protected void makeSelectionHandler(SharedClassChooser<OntologyDropdown> classChooser) {
		classChooser.addSelectionListener(new EntitySelectionListener() {
			@Override
			public void onSelection(final EIEntity selectedEntity) {
				eiInstance.setInstanceType(selectedEntity);
				ClientOntologyToolsManager.INSTANCE.getEIClass(selectedEntity.getURI(), new EIClassCallback() {
					
					@Override
					public void onSuccess(EIClass result) {
						eiInstance.setInstanceClass(result);
						typeChangeHandler.onTypeChange();
					}
					
					@Override
					public void onFailure(String result) {
						// TODO Auto-generated method stub
						
					}
				});
				
			}
		});
	}
	
	@Override
	protected String getLabel() {
		return "Type";
	}

	@Override
	protected void removeValue() {
		// Deliberate no-op; should we show an alert?
	}
	
	@Override
	public EditWidget duplicateBlank() {
		return null;
		// Deliberate no-op; should we show an alert?
	}
}
