/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

public abstract class EditWidget
extends Composite {
    protected HorizontalPanel widgetPanel = new HorizontalPanel();
    protected EIInstance eiInstance;
    protected EIEntity propertyEntity;
    protected String oldValue;
    protected boolean shouldShowLabel;
    protected Label label;

    EditWidget(EIInstance eiInstance, EIEntity propertyEntity) {
        this.initWidget((Widget)this.widgetPanel);
        this.eiInstance = eiInstance;
        this.propertyEntity = propertyEntity;
        this.label = WidgetUtils.createLabel((EIEntity)propertyEntity);
        this.widgetPanel.add((Widget)this.label);
    }

    protected void setLabelContents(String newContents) {
        Log.info((String)("setting label contents to " + newContents));
        this.label.setText(newContents);
    }

    protected void updateOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    protected void updateOldValue(EIURI oldValue) {
        this.oldValue = oldValue.toString();
    }

    protected abstract void removeValue();

    public abstract EditWidget duplicateBlank();

    protected EIURI getOldEIURIValue() {
        return EIURI.create((String)this.oldValue);
    }

    protected String getOldStringValue() {
        return this.oldValue;
    }

    protected boolean hasOldValue() {
        return this.oldValue != null && !"".equals(this.oldValue);
    }

    public boolean shouldShowLabel() {
        return this.shouldShowLabel;
    }

    protected String getLabel() {
        return this.propertyEntity.getLabel();
    }

    public void setShouldShowLabel(boolean shouldShowLabel) {
        this.shouldShowLabel = shouldShowLabel;
        if (!shouldShowLabel) {
            Log.info((String)"blanking label");
            this.setLabelContents("");
        } else {
            this.setLabelContents(this.getLabel());
        }
    }
}

