/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.FormUtils;
import org.eaglei.datatools.client.ui.FormsPanel;
import org.eaglei.datatools.client.ui.MainPanel;
import org.eaglei.datatools.client.ui.OntologyDropdown;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.suggest.client.EntitySelectionListener;
import org.eaglei.suggest.client.OntologyDropdownBase;
import org.eaglei.suggest.client.SharedClassChooser;

public class FormUtils {
    public String formName = "";
    public EIURI subType = null;
    public String dialogFormName = "";
    public EIURI dialogSubType;
    private boolean isView;
    public boolean isDialog;
    public SharedClassChooser<OntologyDropdown> classChooser;
    public List<TextBox> dataList = new ArrayList();
    public List<ListBox> objList = new ArrayList();
    final VerticalPanel formFieldsPanel = new VerticalPanel();
    final VerticalPanel dialogFieldsPanel;
    public boolean isPhoneValid;
    public boolean isEmailValid;
    public FormsPanel frmPanel;

    public FormUtils(FormsPanel frmPanel) {
        this.formFieldsPanel.setStyleName("formPanel");
        this.dialogFieldsPanel = new VerticalPanel();
        this.frmPanel = frmPanel;
        this.isPhoneValid = true;
        this.isEmailValid = true;
    }

    public VerticalPanel createTextField(EIInstance instance, EIEntity entity, Set<String> values, String propertyLabel, boolean isPresent, TextFieldCallback callback) {
        VerticalPanel vPanel = new VerticalPanel();
        HorizontalPanel hPanel = new HorizontalPanel();
        vPanel.add((Widget)hPanel);
        Label label = new Label(propertyLabel);
        Label errLabel = new Label();
        errLabel.setStyleName("errorMsg");
        label.setStyleName("formLabel");
        hPanel.add((Widget)label);
        if (values != null) {
            int item = 0;
            for (String value : values) {
                HorizontalPanel hp = new HorizontalPanel();
                Label l = new Label("");
                l.setStyleName("formLabel");
                TextBox textBox = new TextBox();
                Hidden oldValue = new Hidden();
                textBox.setStyleName("formText");
                if (!this.isDialog) {
                    textBox.setValue(this.formatText(value));
                    oldValue.setValue(this.formatText(value));
                }
                textBox.setName(entity.getURI() + "|" + entity.getLabel());
                if (this.isDialog) {
                    this.dataList.add(textBox);
                } else {
                    this.dataList.add(textBox);
                }
                textBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
                if (propertyLabel.equalsIgnoreCase("phone number")) {
                    textBox.setMaxLength(13);
                    this.addPhoneValidations(propertyLabel, errLabel, textBox);
                } else if (propertyLabel.equalsIgnoreCase("email")) {
                    this.addEmailValidations(propertyLabel, errLabel, textBox);
                }
                if (item > 0) {
                    hp.add((Widget)l);
                    hp.add((Widget)textBox);
                    hp.add((Widget)oldValue);
                    Label deleteField = new Label("-");
                    hp.add((Widget)deleteField);
                    deleteField.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                    vPanel.add((Widget)hp);
                } else {
                    Label addField = new Label("+");
                    addField.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                    hPanel.add((Widget)textBox);
                    hPanel.add((Widget)addField);
                    hPanel.add((Widget)errLabel);
                }
                ++item;
            }
        } else {
            TextBox textBox = new TextBox();
            Hidden oldValue = new Hidden();
            textBox.setStyleName("formText");
            hPanel.add((Widget)textBox);
            hPanel.add((Widget)oldValue);
            hPanel.add((Widget)errLabel);
            boolean isValid = true;
            textBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            if (propertyLabel.equalsIgnoreCase("phone number")) {
                textBox.setMaxLength(13);
                this.addPhoneValidations(propertyLabel, errLabel, textBox);
            } else if (propertyLabel.equalsIgnoreCase("email")) {
                this.addEmailValidations(propertyLabel, errLabel, textBox);
            }
            if (isValid && !isPresent) {
                if (!propertyLabel.equals("Term request")) {
                    Label addField = new Label("+");
                    hPanel.add((Widget)addField);
                    addField.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else {
                Label deleteField = new Label("-");
                if (!propertyLabel.equals("Term request")) {
                    hPanel.add((Widget)deleteField);
                    deleteField.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                }
            }
        }
        return vPanel;
    }

    private Label addPhoneValidations(String propertyLabel, Label errLabel, TextBox textBox) {
        textBox.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        return errLabel;
    }

    private Label addEmailValidations(String propertyLabel, Label errLabel, TextBox textBox) {
        textBox.addBlurHandler((BlurHandler)new /* Unavailable Anonymous Inner Class!! */);
        return errLabel;
    }

    public VerticalPanel createLabelforView(EIEntity entity, Set<String> values, String propertyLabel, boolean isPresent) {
        VerticalPanel vPanel = new VerticalPanel();
        HorizontalPanel hPanel = new HorizontalPanel();
        vPanel.add((Widget)hPanel);
        Label label = new Label(propertyLabel);
        label.setStyleName("formLabel");
        int item = 0;
        if (values != null) {
            hPanel.add((Widget)label);
            for (String value : values) {
                HorizontalPanel hp = new HorizontalPanel();
                Label l = new Label("");
                l.setStyleName("formLabel");
                Anchor resourceURL = null;
                Label valueField = new Label();
                valueField.setStyleName("formLabelValue");
                if (value.startsWith("www") || value.startsWith("http")) {
                    resourceURL = new Anchor(this.formatText(value), this.formatText(value), "_blank");
                } else {
                    valueField.setText(this.formatText(value));
                }
                if (item > 0) {
                    hp.add((Widget)l);
                    hp.add((Widget)(resourceURL == null ? valueField : resourceURL));
                    vPanel.add((Widget)hp);
                } else {
                    hPanel.add((Widget)(resourceURL == null ? valueField : resourceURL));
                }
                ++item;
            }
        } else {
            hPanel.add((Widget)new Label(""));
        }
        return vPanel;
    }

    public HorizontalPanel createRadioButon(EIInstance instance, EIEntity entity, String value) {
        HorizontalPanel hPanel = new HorizontalPanel();
        Label label = new Label(entity.getLabel());
        label.setStyleName("formLabel");
        CheckBox checkBox = new CheckBox();
        TextBox textBox = new TextBox();
        textBox.setName(entity.getURI() + "|" + entity.getLabel());
        textBox.setValue("false");
        if (value != null) {
            checkBox.setValue(Boolean.valueOf(value));
            textBox.setValue(value);
        }
        hPanel.add((Widget)label);
        hPanel.add((Widget)checkBox);
        if (this.isView) {
            checkBox.setEnabled(false);
        }
        checkBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return hPanel;
    }

    public VerticalPanel displayDefaultFields(EIInstance modelInstance, EIClass eClass, String nameValue, String eagleIURI, EIURI subTypeUri, boolean isTypeView) {
        VerticalPanel vPanel = new VerticalPanel();
        vPanel.setStyleName("formPanel");
        HorizontalPanel namepanel = new HorizontalPanel();
        if (!nameValue.equals("")) {
            this.formName = nameValue;
        }
        this.isView = isTypeView;
        TextBox name = new TextBox();
        name.setStyleName("formText");
        name.setValue(nameValue);
        if (this.isView) {
            name.setEnabled(false);
        }
        Label lb = new Label("Resource Name");
        lb.setStyleName("formLabel");
        Label required = new Label("*");
        required.setStyleName("fieldRequired");
        namepanel.add((Widget)required);
        namepanel.add((Widget)lb);
        namepanel.add((Widget)name);
        vPanel.add((Widget)namepanel);
        name.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        if (subTypeUri != null) {
            try {
                ClientOntologyToolsManager.INSTANCE.getEIClass(subTypeUri, (ClientOntologyToolsManager.EIClassCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Log.info((String)("creating term widget for " + eClass));
            vPanel.add((Widget)this.createTermWidget(modelInstance, eClass, null, null, null, Boolean.valueOf(true)));
        }
        return vPanel;
    }

    public VerticalPanel handleObjectProperty(EIInstance instance, List<EIClass> rangeList, EIEntity propertyEntity, Set<EIURI> propertyValues) {
        VerticalPanel vPanel = new VerticalPanel();
        if (propertyValues != null) {
            if (this.isView) {
                this.viewObjectProperty(propertyEntity, propertyValues, vPanel);
            } else {
                Label lbl = new Label(propertyEntity.getLabel());
                lbl.setStyleName("formLabel");
                vPanel.add((Widget)lbl);
                ArrayList classList = new ArrayList();
                for (EIURI uri : propertyValues) {
                    try {
                        ClientRepositoryToolsManager.INSTANCE.getInstance(uri, (ClientRepositoryToolsManager.EIInstanceCallback)new /* Unavailable Anonymous Inner Class!! */);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                13 timer = new /* Unavailable Anonymous Inner Class!! */;
                timer.schedule(2000);
            }
        } else {
            VerticalPanel vp = new VerticalPanel();
            String label = "";
            for (EIClass range : rangeList) {
                label = rangeList.indexOf(range) == 0 ? propertyEntity.getLabel() : "";
                if (range.isEagleIResource()) {
                    vp.add((Widget)this.createWidgetForEIResource(instance, range, propertyEntity, "", label));
                    continue;
                }
                vp.add((Widget)this.createTermWidget(instance, range, null, propertyEntity, label, Boolean.valueOf(true)));
            }
            vPanel.add((Widget)vp);
        }
        return vPanel;
    }

    private void viewObjectProperty(EIEntity propertyEntity, Set<EIURI> propertyValues, VerticalPanel vPanel) {
        ArrayList<EIURI> list = new ArrayList<EIURI>();
        list.addAll(propertyValues);
        for (EIURI uri : list) {
            ClientRepositoryToolsManager.INSTANCE.retrieveLabel(uri, (ClientRepositoryToolsManager.ResultsCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public VerticalPanel displayFormFields(EIClass eClass, EIInstance instance, boolean isTypeView) {
        this.isView = isTypeView;
        Map dataTypeProperties = instance.getDatatypeProperties();
        Map objectTypeProperties = instance.getObjectProperties();
        if (this.isDialog) {
            this.dialogFieldsPanel.clear();
        } else {
            this.formFieldsPanel.clear();
            this.dataList.clear();
            this.objList.clear();
        }
        VerticalPanel vp = new VerticalPanel();
        DeferredCommand.addCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        if (this.isDialog) {
            this.dialogFieldsPanel.add((Widget)vp);
            return this.dialogFieldsPanel;
        }
        this.formFieldsPanel.add((Widget)vp);
        return this.formFieldsPanel;
    }

    private String getEntityLabel(EIEntity entity, Map<EIEntity, String> retrievedLabels) {
        String retrieved = retrievedLabels.get(entity);
        return retrieved == null || retrieved.equals("") ? entity.getLabel() : retrieved;
    }

    public DisclosurePanel displayNonOntologyProperties(EIInstance instance) {
        DisclosurePanel mainPanel = new DisclosurePanel("Information for data curators");
        VerticalPanel metaPanel = new VerticalPanel();
        VerticalPanel otherPanel = new VerticalPanel();
        VerticalPanel vp = new VerticalPanel();
        HorizontalPanel h = new HorizontalPanel();
        h.setStyleName("formPanel");
        Label uriLabel = new Label("eagle-i unique ID");
        uriLabel.setStyleName("formLabel");
        Anchor id = new Anchor(instance.getInstanceURI().toString(), instance.getInstanceURI().toString(), "_blank");
        h.add((Widget)uriLabel);
        h.add((Widget)id);
        vp.add((Widget)h);
        vp.add((Widget)metaPanel);
        vp.add((Widget)otherPanel);
        metaPanel.setStyleName("formPanel");
        otherPanel.setStyleName("formPanel");
        Map nonOntLiteralList = instance.getNonOntologyLiteralProperties();
        Map nonOntResourceList = instance.getNonOntologyResourceProperties();
        if (this.isView) {
            Label metaProps = new Label("Metadata properties:");
            metaProps.setStyleName("nonOntologyPropertyLabel");
            metaPanel.add((Widget)metaProps);
            ArrayList entityList = new ArrayList();
            HashMap valuesEntityMap = new HashMap();
            entityList.addAll(instance.getReadOnlyLiteralProperties().keySet());
            entityList.addAll(instance.getReadOnlyResourceProperties().keySet());
            entityList.addAll(nonOntResourceList.keySet());
            entityList.addAll(nonOntLiteralList.keySet());
            ClientRepositoryToolsManager.INSTANCE.retrieveLabels(entityList, (ClientRepositoryToolsManager.LabelsCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            for (EIEntity entity : nonOntLiteralList.keySet()) {
                if (instance.getReadOnlyLiteralProperties().containsKey(entity) || entity.getURI().toString().equals("http://eagle-i.org/ont/datatools/1.0/user_comments") || entity.getURI().toString().equals("http://purl.obolibrary.org/obo/IAO_0000232")) continue;
                HorizontalPanel hp = new HorizontalPanel();
                Label lbl = new Label(entity.getLabel());
                lbl.setStyleName("formLabel");
                TextBox t = new TextBox();
                t.setStyleName("formText");
                Set values = (Set)nonOntLiteralList.get(entity);
                if (values != null) {
                    String value = (String)values.iterator().next();
                    t.setValue(value);
                }
                String oldValue = t.getValue().equals("") ? null : t.getValue();
                t.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
                hp.add((Widget)lbl);
                hp.add((Widget)t);
                otherPanel.add((Widget)hp);
            }
            for (EIEntity entity : nonOntResourceList.keySet()) {
                if (instance.getReadOnlyResourceProperties().containsKey(entity)) continue;
                for (EIURI uri : (Set)nonOntResourceList.get(entity)) {
                    HorizontalPanel hp = new HorizontalPanel();
                    Label l = new Label(entity.getLabel());
                    l.setStyleName("formLabel");
                    TextBox t = new TextBox();
                    t.setStyleName("formText");
                    t.setValue(uri.toString());
                    EIURI oldValue = uri;
                    hp.add((Widget)l);
                    hp.add((Widget)t);
                    t.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
                    otherPanel.add((Widget)hp);
                }
            }
        }
        mainPanel.add((Widget)vp);
        return mainPanel;
    }

    private HorizontalPanel createTextArea(EIInstance instance, EIEntity entity, Set<String> values) {
        Log.info((String)("creating text area for " + entity.getLabel() + " with " + (values == null ? "0" : Integer.valueOf(values.size())) + " values"));
        HorizontalPanel hp = new HorizontalPanel();
        Label lbl = new Label(entity.getLabel());
        lbl.setStyleName("formLabel");
        if (entity.getURI().toString().equals("http://purl.obolibrary.org/obo/IAO_0000232")) {
            lbl.setText("Curator note");
        }
        if (entity.getURI().toString().equals("http://eagle-i.org/ont/datatools/1.0/user_comments")) {
            lbl.setText("Comments");
        }
        TextArea ta = new TextArea();
        if (values != null) {
            for (String value : values) {
                if (this.isDialog) continue;
                ta.setText(value);
                Log.info((String)(" interim text area value" + ta.getValue()));
            }
            Log.info((String)("final text area value" + ta.getValue()));
        }
        ta.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        hp.add((Widget)lbl);
        hp.add((Widget)ta);
        return hp;
    }

    public VerticalPanel createTermWidget(EIInstance instance, EIClass range, EIClass selectedClass, EIEntity propertyEntity, String label, Boolean isAddfield) {
        HorizontalPanel hPanel = new HorizontalPanel();
        VerticalPanel vPanel = new VerticalPanel();
        Label pLabel = new Label();
        ListBox lb = new ListBox();
        Hidden oldValue = new Hidden();
        if (propertyEntity != null) {
            if (label == null) {
                pLabel.setText(propertyEntity.getLabel());
            } else {
                pLabel.setText(label);
            }
            lb.setName(propertyEntity.getURI() + "|" + propertyEntity.getLabel());
        } else {
            pLabel.setText("Type");
        }
        pLabel.setStyleName("formLabel");
        this.classChooser = new SharedClassChooser((OntologyDropdownBase)new OntologyDropdown());
        this.classChooser.setTextBoxStyle("textSuggest");
        if (!this.isView) {
            hPanel.add((Widget)pLabel);
            if (!this.isDialog && propertyEntity == null) {
                this.subType = selectedClass != null ? selectedClass.getEntity().getURI() : range.getEntity().getURI();
            }
            this.classChooser.setClass(range, false);
            if (propertyEntity != null) {
                if (selectedClass != null) {
                    this.classChooser.setSelectedEntity(selectedClass.getEntity());
                    lb.addItem(selectedClass.getEntity().getURI().toString());
                    oldValue.setValue(selectedClass.getEntity().getURI().toString());
                } else {
                    lb.addItem(range.getEntity().getURI().toString());
                }
            } else if (selectedClass != null) {
                this.classChooser.setSelectedEntity(selectedClass.getEntity());
            }
            hPanel.add((Widget)this.classChooser);
        } else {
            if (selectedClass != null) {
                hPanel.add((Widget)pLabel);
                this.classChooser.setClass(selectedClass, false);
                hPanel.add((Widget)this.classChooser);
            }
            this.classChooser.setEnabled(false);
        }
        this.classChooser.addSelectionListener((EntitySelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        EIEntity termRequestEntity = EIEntity.create((String)"http://eagle-i.org/ont/datatools/1.0/has_term_request", (String)"has term request");
        if (!this.isView) {
            hPanel.add((Widget)this.createTextField(instance, termRequestEntity, null, "Term request", false, (TextFieldCallback)new /* Unavailable Anonymous Inner Class!! */));
            if (propertyEntity != null) {
                Label addNew = new Label("+");
                addNew.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                Label removeItem = new Label("-");
                removeItem.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                if (!isAddfield.booleanValue()) {
                    hPanel.add((Widget)removeItem);
                } else {
                    hPanel.add((Widget)addNew);
                }
            }
        }
        vPanel.add((Widget)hPanel);
        return vPanel;
    }

    private VerticalPanel createWidgetForEIResource(EIInstance instance, EIClass range, EIEntity propertyEntity, String propertyValue, String propLabel) {
        HorizontalPanel hPanel = new HorizontalPanel();
        VerticalPanel vp = new VerticalPanel();
        ListBox subClassList = new ListBox();
        subClassList.setWidth("70");
        subClassList.addItem("<select>", null);
        subClassList.addItem("<create new>", null);
        Label lbl = new Label(propLabel);
        lbl.setStyleName("formLabel");
        TextBox valueBox = new TextBox();
        valueBox.setStyleName("formText");
        Hidden oldValue = new Hidden();
        if ("".equals(propertyValue)) {
            valueBox.setStyleName("textSuggest");
            valueBox.setValue(range.getEntity().getLabel());
        } else {
            valueBox.setValue(propertyValue);
        }
        valueBox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        subClassList.setName(propertyEntity.getURI() + "|" + propertyEntity.getLabel());
        this.objList.add(subClassList);
        oldValue.setValue(subClassList.getValue(subClassList.getSelectedIndex()));
        hPanel.setSpacing(25);
        Anchor link = new Anchor();
        if (!this.isView) {
            hPanel.add((Widget)lbl);
            hPanel.add((Widget)valueBox);
            hPanel.add((Widget)subClassList);
            Label addField = new Label("+");
            addField.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            Label removeField = new Label("-");
            removeField.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            if (propLabel != null) {
                hPanel.add((Widget)addField);
            } else {
                hPanel.add((Widget)removeField);
            }
        } else if (!propertyValue.equals("")) {
            Label label = new Label(propLabel);
            label.setStyleName("formLabel");
            hPanel.add((Widget)label);
            hPanel.add((Widget)new Label(propertyValue));
        }
        ClientRepositoryToolsManager.INSTANCE.getResourcesOfClass(MainPanel.userUri, range.getEntity().getURI(), (ClientRepositoryToolsManager.EIInstancesCallback)new /* Unavailable Anonymous Inner Class!! */);
        subClassList.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        subClassList.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        vp.add((Widget)hPanel);
        return vp;
    }

    protected String getUriForValue(ListBox listBox, String oldValue) {
        Log.info((String)("  list box length " + listBox.getItemCount()));
        for (int i = 0; i < listBox.getItemCount(); ++i) {
            if (!listBox.getItemText(i).startsWith(oldValue)) continue;
            Log.info((String)("  old value " + listBox.getValue(i)));
            return listBox.getValue(i);
        }
        Log.info((String)("  failed to find " + oldValue));
        return "";
    }

    public void createDialog(EIInstance parentInstance, EIEntity property, EIClass range, ListBox subClassList, TextBox textBox, Hidden oldValue) {
        HorizontalPanel hpanel = new HorizontalPanel();
        PopupPanel window = new PopupPanel();
        VerticalPanel vPanel = new VerticalPanel();
        Button save = new Button("Save");
        Button closeButton = new Button("Close");
        window.setModal(true);
        this.isDialog = true;
        ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance(range.getEntity().getURI(), (ClientRepositoryToolsManager.EIInstanceCallback)new /* Unavailable Anonymous Inner Class!! */);
        closeButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        save.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        int left = Window.getClientWidth() / 2;
        int top = Window.getClientHeight() / 3;
        window.setWidget((Widget)vPanel);
        window.setStyleName("dialogWindow");
        window.setPopupPosition(left, top);
        window.show();
        Style style = window.getElement().getStyle();
        style.clearOverflow();
    }

    private void handleLoginRequired() {
        Window.alert((String)"Please log in.");
    }

    private String formatText(String value) {
        if (value.indexOf("^") > 0) {
            return value.substring(0, value.indexOf("^"));
        }
        return value;
    }

    public boolean isFormValid() {
        return this.isPhoneValid && this.isEmailValid;
    }

    public void clearAll() {
        this.dataList.clear();
        this.objList.clear();
        this.dataList.clear();
        this.objList.clear();
    }

    protected EIEntity makeEntityFromWidgetName(String name) {
        return EIEntity.create((String)name.substring(0, name.indexOf("|")), (String)name.substring(name.indexOf("|") + 1));
    }

    private void doOnChange(EIInstance instance, EIClass range, EIEntity propertyEntity, String propertyValue, ListBox subClassList, TextBox valueBox, Hidden oldValue) {
        if (subClassList.getItemText(subClassList.getSelectedIndex()) == "<select>") {
            Window.alert((String)("Please select a valid value for " + propertyEntity.getLabel()));
        } else if (subClassList.getItemText(subClassList.getSelectedIndex()).equals("<create new>")) {
            this.frmPanel.onCreateNewClicked(instance, propertyEntity, range, subClassList, valueBox, oldValue);
        } else {
            Log.info((String)("replacing object property value  for " + propertyEntity + " old value " + propertyValue + " new value " + subClassList.getValue(subClassList.getSelectedIndex())));
            instance.replaceObjectPropertyValue(propertyEntity, EIURI.create((String)this.getUriForValue(subClassList, valueBox.getText())), EIURI.create((String)subClassList.getValue(subClassList.getSelectedIndex())));
            Log.info((String)("new object property value list is " + instance.getObjectProperty(propertyEntity)));
            valueBox.setValue(this.getTextValue(subClassList));
        }
    }

    private String getTextValue(ListBox subClassList) {
        String currentValue = subClassList.getItemText(subClassList.getSelectedIndex());
        if (currentValue.indexOf(" <") < 0) {
            return currentValue;
        }
        return currentValue.substring(0, currentValue.indexOf(" <"));
    }

    protected void updateInstanceType(EIInstance instance, EIEntity newInstanceType, EIClass newClass) {
        ClientOntologyToolsManager.INSTANCE.getProperties(newClass, (ClientOntologyToolsManager.PropertyCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ String access$000(FormUtils x0, String x1) {
        return x0.formatText(x1);
    }

    static /* synthetic */ Label access$100(FormUtils x0, String x1, Label x2, TextBox x3) {
        return x0.addPhoneValidations(x1, x2, x3);
    }

    static /* synthetic */ Label access$200(FormUtils x0, String x1, Label x2, TextBox x3) {
        return x0.addEmailValidations(x1, x2, x3);
    }

    static /* synthetic */ VerticalPanel access$300(FormUtils x0, EIInstance x1, EIClass x2, EIEntity x3, String x4, String x5) {
        return x0.createWidgetForEIResource(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ void access$400(FormUtils x0) {
        x0.handleLoginRequired();
    }

    static /* synthetic */ boolean access$500(FormUtils x0) {
        return x0.isView;
    }

    static /* synthetic */ HorizontalPanel access$600(FormUtils x0, EIInstance x1, EIEntity x2, Set x3) {
        return x0.createTextArea(x1, x2, x3);
    }

    static /* synthetic */ String access$700(FormUtils x0, EIEntity x1, Map x2) {
        return x0.getEntityLabel(x1, x2);
    }

    static /* synthetic */ void access$800(FormUtils x0, EIInstance x1, EIClass x2, EIEntity x3, String x4, ListBox x5, TextBox x6, Hidden x7) {
        x0.doOnChange(x1, x2, x3, x4, x5, x6, x7);
    }
}

