/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.ui.ApplicationImages;
import org.eaglei.model.EIClass;
import org.eaglei.suggest.client.OntologyDropdownBase;

public class OntologyDropdown
extends OntologyDropdownBase {
    public void setResource(EIClass resource) {
        if (resource != null) {
            this.rootClass = resource;
            if (this.tree != null) {
                this.tree.clear();
                this.scroll.getElement().getStyle().clearHeight();
            }
            if (this.rootClass.hasSubClass()) {
                if (this.tree != null) {
                    this.tree.add((Widget)ApplicationImages.LOADING);
                }
                this.rootListLoading = true;
            } else if (this.tree != null) {
                this.tree.addItem("No types are available");
            }
        } else {
            this.setTitle("There are currently no sub-classes for this class in the Ontology.");
            this.button.setVisible(false);
            this.setStyleName("OntologyDropDownNoTerm");
        }
    }

    protected void doOnClick(ClickEvent event) {
        if (this.rootClass != null && this.rootListLoading) {
            DeferredCommand.addCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.popup != null) {
            this.popup.setVisible(false);
            this.popup.show();
            this.setPopupHeight();
        }
    }

    protected void populateChildList(TreeItem item) {
        OntologyDropdownBase.ResourceTreeWidget w = (OntologyDropdownBase.ResourceTreeWidget)item.getWidget();
        EIClass resource = w.getResource();
        if (resource.getSubClasses() != null) {
            this.populateChildList(item, w, resource.getSubClasses());
        } else {
            ClientOntologyToolsManager.INSTANCE.getSubClasses(resource.getEntity().getURI(), true, (ClientOntologyToolsManager.EISubClassCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected void populateChildList(TreeItem parent, OntologyDropdownBase.ResourceTreeWidget parentWidget, List<EIClass> subclasses) {
        parent.removeItems();
        for (EIClass r : subclasses) {
            OntologyDropdownBase.ResourceTreeWidget childWidget = new OntologyDropdownBase.ResourceTreeWidget((OntologyDropdownBase)this, r);
            TreeItem child = parent.addItem((Widget)childWidget);
            if (!r.hasSubClass()) continue;
            child.addItem((Widget)ApplicationImages.LOADING);
            childWidget.childListLoading = true;
        }
        parentWidget.childListLoading = false;
        this.setPopupHeight();
    }

    private void setPopupHeight() {
        DeferredCommand.addCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    private int computeMaxHeight() {
        int top = this.p.getAbsoluteTop();
        int windowTop = Window.getScrollTop();
        int windowBottom = Window.getScrollTop() + Window.getClientHeight();
        int distanceFromWindowTop = top - windowTop;
        int distanceToWindowBottom = windowBottom - (top + this.p.getOffsetHeight());
        if (distanceToWindowBottom > 200) {
            return distanceToWindowBottom - 10;
        }
        if (distanceFromWindowTop > 200) {
            return distanceFromWindowTop - 10;
        }
        return distanceToWindowBottom > distanceFromWindowTop ? distanceToWindowBottom - 10 : distanceFromWindowTop - 10;
    }

    static /* synthetic */ boolean access$000(OntologyDropdown x0) {
        return x0.rootListLoading;
    }

    static /* synthetic */ EIClass access$100(OntologyDropdown x0) {
        return x0.rootClass;
    }

    static /* synthetic */ Tree access$200(OntologyDropdown x0) {
        return x0.tree;
    }

    static /* synthetic */ Tree access$300(OntologyDropdown x0) {
        return x0.tree;
    }

    static /* synthetic */ boolean access$402(OntologyDropdown x0, boolean x1) {
        x0.rootListLoading = x1;
        return x0.rootListLoading;
    }

    static /* synthetic */ void access$500(OntologyDropdown x0) {
        x0.setPopupHeight();
    }

    static /* synthetic */ Tree access$600(OntologyDropdown x0) {
        return x0.tree;
    }

    static /* synthetic */ int access$700(OntologyDropdown x0) {
        return x0.computeMaxHeight();
    }

    static /* synthetic */ ScrollPanel access$800(OntologyDropdown x0) {
        return x0.scroll;
    }

    static /* synthetic */ ScrollPanel access$900(OntologyDropdown x0) {
        return x0.scroll;
    }

    static /* synthetic */ HorizontalPanel access$1000(OntologyDropdown x0) {
        return x0.p;
    }

    static /* synthetic */ PopupPanel access$1100(OntologyDropdown x0) {
        return x0.popup;
    }

    static /* synthetic */ EIClass access$1200(OntologyDropdown x0) {
        return x0.rootClass;
    }

    static /* synthetic */ PopupPanel access$1300(OntologyDropdown x0) {
        return x0.popup;
    }
}

