package org.eaglei.datatools.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.datatools.client.ui.WorkFlowAction;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public class WorkFlowConstants {
	// Put URIs here because GWT has trouble with DatatoolsConstants, and we keep using them.
	public static final String WITHDRAW_URI = "http://eagle-i.org/ont/repo/1.0/WFS_Withdrawn";
	public static final String PUBLISH_URI = "http://eagle-i.org/ont/repo/1.0/WFS_Published";
	public static final String CURATION_URI = "http://eagle-i.org/ont/repo/1.0/WFS_Curation";
	public static final String DRAFT_URI = "http://eagle-i.org/ont/repo/1.0/WFS_Draft";
	// Include all UI labels here so they are easily changed
	// Repo Constants from DataToolsOntConstants
	public static final String EAGLE_I_REPO_URI = "http://eagle-i.org/ont/repo/1.0/";
	// Bulk Workflow alerts
	public static final String NO_DRAFT_MESSAGE = "Only resources in 'draft' state can be sent to curation.";
	public static final String NO_CURATION_MESSAGE = "Only 'withdrawn' resources or resources in 'in curation' state can be published.";
	public static final String NO_WITHDRAWN = "Only resources in 'published' state can be withdrawn.";
	public static final String NO_RETURNTODRAFT = "Only resources in 'in curation' state can be returned to draft.";
	public static final String SELECT_MESSAGE = "Please select resources and choose action.";
	// Form actions and alerts
	public static final String SAVE_SUCCESS = "Resource has been saved.";
	public static final String LABEL_REQUIRED = "Name is a required field.";
	public static final String NOT_IN_LIST = "Resource was not found in the repository; Please select '<create new>' in the list to add a new resource.";
	public static final String INVALID_VALUE = "Please select a valid value for ";
	public static final String SAVE_SUCCESS_LIGHTBOX = "Resource has been saved; please close the dialog to reflect changes.";
	public static final String BULK_OPERATION_ERROR = "Only resources in $STATE$ can be $ACTION$";
	public static final String NO_ONTOLOGY_TERMS = "There are currently no sub-classes for this class in the Ontology.";
	public static final String CONFIRM_DELETE = "Are you sure you want to delete this row?";
	public static final String NO_TOKEN_AVAILABLE = "Currently unable to edit this resource.  Please logout and try again.";
	// Login
	public static final String PLEASE_LOGIN = "Please log in.";
	public static final String NO_USER = "A user name is required.";
	public static final String NO_PASSWORD = "A password is required.";
	// Buttons and states labels
	public static final String FORM_ACTIONS_TITLE = "Form Actions";
	public static final String WORKFLOW_ACTIONS_TITLE = "Workflow Actions";
	// Actions (to be displayed in buttons and lists of actions)
	public static final String SAVE_ACTION = "Save Resource";
	public static final String DUPLICATE_ACTION = "Duplicate Resource";
	public static final String EDIT_ACTION = "Edit Resource";
	public static final String CURATION_ACTION = "Send to Curation";
	public static final String PUBLISH_ACTION = "Publish";
	public static final String DRAFT_ACTION = "Return to Draft";
	public static final String WITHDRAW_ACTION = "Withdraw";
	// States
	public static final String CURATION_STATE = "In curation";
	public static final String PUBLISH_STATE = "Published";
	public static final String DRAFT_STATE = "Draft";
	public static final String WITHDRAW_STATE = "Withdrawn";
	
	// State entities
	public static final EIEntity CURATION_ENTITY = EIEntity.create(CURATION_URI, CURATION_STATE);
	public static final EIEntity PUBLISH_ENTITY = EIEntity.create(PUBLISH_URI, PUBLISH_STATE);
	public static final EIEntity DRAFT_ENTITY = EIEntity.create(DRAFT_URI, DRAFT_STATE);
	public static final EIEntity WITHDRAW_ENTITY = EIEntity.create(WITHDRAW_URI, WITHDRAW_STATE);
	
	public static final Map<EIURI, EIEntity> WORKFLOW_URI_MAP = new HashMap<EIURI, EIEntity>() {
		{
			put(EIURI.create(CURATION_URI), CURATION_ENTITY);
			put(EIURI.create(PUBLISH_URI), PUBLISH_ENTITY);
			put(EIURI.create(DRAFT_URI), DRAFT_ENTITY);
			put(EIURI.create(WITHDRAW_URI), WITHDRAW_ENTITY);
		}
	};
	
	//Property URIs
	public static final String COMMENTS = "http://eagle-i.org/ont/datatools/1.0/user_comments";
	public static final String COMMENTS_LABEL = "Comments";
	public static final String CURATOR_NOTE = "http://purl.obolibrary.org/obo/IAO_0000232";
	public static final String CURATOR_LABEL = "Curator note";
	
	
	public static final Map<String, List<String>> ALLOWED_TRANSITIONS = new HashMap<String, List<String>>() {
		{
			put(DRAFT_STATE, Arrays.asList(new String[] { CURATION_STATE }));
			put(CURATION_STATE, Arrays.asList(new String[] { DRAFT_STATE,
					PUBLISH_STATE }));
			put(PUBLISH_STATE, Arrays.asList(new String[] { WITHDRAW_STATE }));
			put(WITHDRAW_STATE, Arrays.asList(new String[] { PUBLISH_STATE }));
		}
	};

	public static final Map<String, List<WorkFlowAction>> ALLOWED_ACTION_TRANSITIONS = new HashMap<String, List<WorkFlowAction>>() {
		{
			put(DRAFT_STATE, Arrays.asList(new WorkFlowAction[] { WorkFlowAction.CurationAction }));
			put(CURATION_STATE, Arrays.asList(new WorkFlowAction[] { WorkFlowAction.ReturnToDraftAction,
					WorkFlowAction.PublishAction }));
			put(PUBLISH_STATE, Arrays.asList(new WorkFlowAction[] { WorkFlowAction.WithdrawAction }));
			put(WITHDRAW_STATE, Arrays.asList(new WorkFlowAction[] { WorkFlowAction.PublishAction }));
		}
	};
	

	// Map these to UI labels above (these are used in the code; Priti, maybe
	// use the constants above in the code to avoid confusions)
	// public static final String SAVE_AS_DRAFT = DRAFT_STATE;
	// public static final String PUBLISHED = PUBLISH_STATE;
	// DRAFpublic static final String READY_FOR_CURATION = CURATION_STATE;
	private String statusType;

	public String getStatusType() {
		return statusType;
	}

	public String getStatusType(String eiuri) {
		if (DRAFT_URI.equals(eiuri))
			return DRAFT_STATE;
		else if (CURATION_URI.equals(eiuri))
			return CURATION_STATE;
		else if (PUBLISH_URI.equals(eiuri))
			return PUBLISH_STATE;
		else if (WITHDRAW_URI.equals(eiuri))
			return WITHDRAW_STATE;
		else if (DRAFT_STATE.equals(eiuri))
			return DRAFT_STATE;
		else if (CURATION_STATE.equals(eiuri))
			return CURATION_STATE;
		else if (PUBLISH_STATE.equals(eiuri))
			return PUBLISH_STATE;
		else if (WITHDRAW_STATE.equals(eiuri))
			return WITHDRAW_STATE;
		return "";
	}

	// TODO: get rid of this.  The only difference with getStatusType is returning null;
	// otherwise it's a subset.  Dumb.
	public String getStatusTypeByStatusURI(String eiuri) {
		if (DRAFT_URI.equals(eiuri))
			return DRAFT_STATE;
		else if (CURATION_URI.equals(eiuri))
			return CURATION_STATE;
		else if (PUBLISH_URI.equals(eiuri))
			return PUBLISH_STATE;
		else if (WITHDRAW_URI.equals(eiuri))
			return WITHDRAW_STATE;
		else
			return null;
	}

	public EIURI getStatusURI(String status) {
		if (DRAFT_STATE.equals(status))
			return EIURI.create(DRAFT_URI);
		else if (CURATION_STATE.equals(status))
			return EIURI.create(CURATION_URI);
		else if (PUBLISH_STATE.equals(status))
			return EIURI.create(PUBLISH_URI);
		else if (WITHDRAW_STATE.equals(status))
			return EIURI.create(WITHDRAW_URI);
		return null;
	}
	
	public boolean canPerform(String action, String status) {
		if (ALLOWED_ACTION_TRANSITIONS.containsKey(status))
			return ALLOWED_ACTION_TRANSITIONS.get(status).contains(action);
		else if (ALLOWED_ACTION_TRANSITIONS.containsKey(getStatusType(status)))
			return ALLOWED_ACTION_TRANSITIONS.get(status).contains(getStatusType(action));
		
		return false;
	}
}
