package org.eaglei.datatools.client.rpc;

import java.util.List;

import org.eaglei.model.EIClass;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;



/**
 * The client side stub for the RPC service.
 */

@RemoteServiceRelativePath("ontology")
public interface OntologyToolsModelService extends RemoteService{
	
	List<EIClass> getTopLevelClasses() throws Exception;
	
	EIClass getEIClass(EIURI uri);
	
	List<EIProperty> getProperties(EIURI classId) ;
	
	List<EIProperty> getProperties(EIURI classId, String groupUri) ;
	
	List<EIClass> getSubClasses(EIURI classId, boolean resolveReference) throws Exception;
	
	List<String> getClassDefinitions(List<EIURI> classURIs) throws Exception;
	
	EIClass getSuperClass(EIClass eclass);
	
	EIClass getRootSuperClass(EIClass eclass);
}
