package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.ResultsCallback;
import org.eaglei.model.EIInstance;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

public class ButtonsPanel extends Composite {
	interface Binder extends UiBinder<Widget, ButtonsPanel> {
	}
	private static final Binder	binder = GWT.create(Binder.class);

	@UiField
	Label	formControlLabel;
	@UiField
	Label	wfLabel;
	@UiField
	Button	curationButton;
	@UiField
	Button	saveButton;
	@UiField
	Button	publishButton;
	@UiField
	Button	backToDraftButton;
	@UiField
	Button	withdrawButton;
	@UiField
	Button	editButton;
	@UiField
	Button	cancelButton;
	@UiField
	Button	copyResourceButton;
	
	private String wfState;
	private EIInstance instance;
	private FormRedisplay redisplay;
	
	// TODO: get rid of wfState from here
	ButtonsPanel(String wfState, EIInstance anInstance, FormRedisplay aRedisplay) {
		initWidget(binder.createAndBindUi(this));
		this.wfState = wfState;
		this.instance = anInstance;
		this.redisplay = aRedisplay;
		
		setTransitionButtonState(curationButton, WorkFlowConstants.CURATION_STATE, WorkFlowConstants.CURATION_URI); // possible to send to curation if you can edit drafts
		setTransitionButtonState(publishButton, WorkFlowConstants.PUBLISH_STATE, WorkFlowConstants.PUBLISH_URI); // possible to publish if you can edit curation
		setTransitionButtonState(backToDraftButton, WorkFlowConstants.DRAFT_STATE, WorkFlowConstants.DRAFT_URI); // possible to return to draft if you can edit curation
		setTransitionButtonState(withdrawButton, WorkFlowConstants.WITHDRAW_STATE, WorkFlowConstants.WITHDRAW_URI);
	}
	
	private void setTransitionButtonState(Button workflowButton, String workflowConstantState, final String workflowUri) {
		// Note: "previous" state refers to the name of the button--only enable
		// if the state associated with the button is
		// the same as the state of the resource, since we call the button with
		// the name of the state that can promote to it
		workflowButton.setVisible(true);
		if (Datatools.canUserChangeState(wfState, workflowConstantState)) {
			workflowButton.setEnabled(true);
			workflowButton.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					try {
						ClientRepositoryToolsManager.INSTANCE.promote(instance, workflowUri, new ResultsCallback() {
							@Override
							public void loginRequired() {
								Window.alert(WorkFlowConstants.PLEASE_LOGIN);
							}
							
							@Override
							public void onSuccess(String arg0) {
								redisplay.drawAfterPromote(instance);
							}
							
							@Override
							public void onSuccess(String[] arg0) {
								redisplay.drawAfterPromote(instance);
							}
						});
					} catch (Exception e) {
						for (StackTraceElement el: e.getStackTrace())
							Log.error(el.toString());
						
					}
				}
			});
		} else {
			disable(workflowButton);
		}
	}
	
	protected void disable(Button workflowButton) {
		workflowButton.setEnabled(false);
		workflowButton.addStyleName("btnDisabled"); 
	}
	
	public Button getSaveButton() {
		return saveButton;
	}
	
	public Button getCancelButton() {
		return cancelButton;
	}
	
	public Button getEditButton() {
		return editButton;
	}
}
