package org.eaglei.datatools.client.ui;

import java.util.List;

import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstancesCallback;
import org.eaglei.datatools.client.ui.WidgetUtils.InstanceSaveCallback;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;

public class EIResourceWidget extends EditWidget{
	
	private static final String CREATE_NEW_VALUE = "<create new>";

	private static final String NO_VALUE = "<none>";

	private TextBox valueField = WidgetUtils.createTextFieldForResourceWidget();
	
	private ListBox instances = new ListBox();
		
	private final EIClass range;
	private boolean shouldHaveLabel;
	
	@Deprecated
	public EIResourceWidget(EIInstance instance, EIEntity propertyEntity, EIClass range, String selectedUri, boolean shouldShowLabel) {
		this(instance, propertyEntity, range, EIEntity.create(selectedUri, ""), shouldShowLabel);
	}
	
	public EIResourceWidget(EIInstance instance, EIEntity propertyEntity, EIClass range, EIEntity selectedEntity, boolean shouldShowLabel) {
		super(instance, propertyEntity);
		this.range = range;
		if (selectedEntity != null && selectedEntity != EIEntity.NULL_ENTITY)
			oldValue = selectedEntity.getURI().toString();
		shouldHaveLabel = shouldShowLabel;
		if (! shouldHaveLabel)
			widgetPanel.remove(label);

		setup();
		intializeInstances();
	}
	
	private void intializeInstances() {
		instances.setWidth("70");
		instances.addItem(NO_VALUE, null);
		instances.addItem(CREATE_NEW_VALUE, null);
		valueField.setText(range.getEntity().getLabel());
		ClientRepositoryToolsManager.INSTANCE.getResourcesOfClass(MainPanel.userUri, range.getEntity().getURI(), new EIInstancesCallback() {
			public void onSuccess(final List<EIInstance> result) {
				for (EIInstance valueInstance : result) {
					String instanceLabel = valueInstance.getEntity().getLabel();
					instances.addItem(formatInstanceForListBox(valueInstance), valueInstance.getInstanceURI().toString());
					if(valueInstance.getInstanceURI().toString().equals(oldValue)) {
						instances.setSelectedIndex(instances.getItemCount() - 1);
						valueField.setText(instanceLabel);
					}
				}
			}
			@Override
			public void loginRequired() {
				//handleLoginRequired();
			}
		});
		
		instances.addChangeHandler(new ChangeHandler() { 
			@Override
			public void onChange(ChangeEvent arg0) {
				doOnChange(eiInstance, range, propertyEntity, oldValue, instances, valueField);
			}
		});
		
		valueField.addValueChangeHandler(new ValueChangeHandler<String>() {
			@Override
			public void onValueChange(ValueChangeEvent<String> arg0) {
				boolean itemFound = false;
				for (int i = 0; i < instances.getItemCount(); i++) {
					if (arg0.getValue().equals(instances.getItemText(i))) {
						itemFound = true;
						break;
					}
				}
				if (!itemFound) {
					Window.alert(WorkFlowConstants.NOT_IN_LIST);
					valueField.setFocus(true);
				}
			}
		});
	}

	private void doOnChange(final EIInstance instance, final EIClass range, final EIEntity propertyEntity, final String propertyValue, final ListBox subClassList, final TextBox valueBox) {
		if (subClassList.getItemText(subClassList.getSelectedIndex()).equals(NO_VALUE)) {
			valueBox.setText("");
			removeValue();
		} else if (subClassList.getItemText(subClassList.getSelectedIndex()).equals(CREATE_NEW_VALUE)) {
			int currentPosition = widgetPanel.getAbsoluteTop();
			PopupPanel dialog = WidgetUtils.createDialog(instance, range, propertyEntity, EIURI.create(oldValue), currentPosition, new InstanceSaveCallback() {				
				@Override
				public void updateState(EIInstance newInstance) {
					valueBox.setValue(newInstance.getInstanceLabel());
					subClassList.addItem(formatInstanceForListBox(newInstance), newInstance.getInstanceURI().toString());
					subClassList.setSelectedIndex(subClassList.getItemCount()-1);
					if(hasOldValue()) {
						eiInstance.replaceObjectPropertyValue(propertyEntity, EIURI.create(oldValue), newInstance.getEntity());
					} else {
						eiInstance.addObjectProperty(propertyEntity, newInstance.getEntity());
					}
					updateOldValue(WidgetUtils.getSelectedUri(subClassList));
				}
			});
			dialog.show();
			Style style = dialog.getElement().getStyle();
			style.clearOverflow();
			
		} else {
			valueField.setValue(getTextValue(subClassList));
			if(hasOldValue()) {
				eiInstance.replaceObjectPropertyValue(propertyEntity, EIURI.create(oldValue), WidgetUtils.getSelectedEntity(subClassList));
			} else {
				eiInstance.addObjectProperty(propertyEntity, WidgetUtils.getSelectedEntity(subClassList));
			}
			updateOldValue(WidgetUtils.getSelectedUri(subClassList));
			
			valueBox.setStyleName("formText");
		}
	}
	
	private String getTextValue(ListBox subClassList) {
		String currentValue = subClassList.getItemText(subClassList.getSelectedIndex());
		return currentValue.substring(0, currentValue.indexOf(" <"));
	}
	
	private void setup() {
		valueField.setName(propertyEntity.getURI().toString() + "_value");
		instances.setName(propertyEntity.getURI().toString() + "_instances");
		widgetPanel.add(valueField);
		widgetPanel.add(instances);
	}
	
	private String formatInstanceForListBox(EIInstance valueInstance) {
		return valueInstance.getInstanceLabel() + " <" + valueInstance.getInstanceType().getLabel() + ">";
	}

	@Override
	public EditWidget duplicateBlank() {
		return new EIResourceWidget(eiInstance, propertyEntity, range, (EIEntity) null, true);
	}

	@Override
	protected void removeValue() {
		if (hasOldValue())
			eiInstance.replaceObjectPropertyValue(propertyEntity, getOldEIURIValue(), null);
	}

	public void disable() {
		valueField.setEnabled(false);
		instances.setEnabled(false);
	}	
}
