package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EISuperClassCallback;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.PropertyCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.ResultsCallback;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;

public class EditFormsPanel extends EIFormsPanel{
	
	static enum EditFormType {
		Edit, New, Dialog;
	}
	
	private EIClass eiClass;
	private final List<EIEntity>  dataPropEntityList = new ArrayList<EIEntity>();
	private final List<EIEntity> booleanPropEntityList = new ArrayList<EIEntity>();
	private final List<EIEntity>  objPropEntityList = new ArrayList<EIEntity>();
	private final Map<EIEntity, List<EIClass>> objectProperties = new HashMap<EIEntity, List<EIClass>>();
	private final EIEntity labEntity;
	private String editToken;
	private final EditFormType formType;
	private final EditFormRedisplay formRedisplayCallbacks;
	
	public static EditFormsPanel createEditForm(EIInstance instance, EIClass eiClass, EIURI labUri, EditFormRedisplay displayCallbacks) {
		return new EditFormsPanel(instance, eiClass, labUri, displayCallbacks, EditFormType.Edit);
	}
	
	public static EditFormsPanel createNewForm(EIInstance instance, EIClass eiClass, EIURI labUri, EditFormRedisplay displayCallbacks) {
		return new EditFormsPanel(instance, eiClass, labUri, displayCallbacks, EditFormType.New);
	}
	
	public static EditFormsPanel createDialogForm(EIInstance instance, EIClass eiClass, EIURI labUri, EditFormRedisplay displayCallbacks) {
		return new EditFormsPanel(instance, eiClass, labUri, displayCallbacks, EditFormType.Dialog);
	}
	
	private EditFormsPanel(EIInstance instance, EIClass eiClass, EIURI labUri, EditFormRedisplay displayCallbacks, EditFormType formType) {
		super(instance, (FormRedisplay) displayCallbacks);
		shouldShowReadOnlyProperties = false;
		this.formRedisplayCallbacks = displayCallbacks;
		this.eiClass = eiClass;
		initializePropertyLists(); // call finishSetup inside the callback--don't do anything until we have properties
		this.formType = formType;
		setButtonState(); // in order to get new/edit
		this.labEntity = (labUri == null  || labUri.toString().equals("")) ? null : EIEntity.create(labUri, ""); // TODO: FIX ME!!
		Log.info("have lab? " + hasLabUri());
		if (!isNewForm())
			getEditToken();
		if (buttonPanel.getSaveButton().isEnabled()) {
			buttonPanel.getSaveButton().addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					save();
				}
			});
		}
		
		if (buttonPanel.getCancelButton().isEnabled()) {
			buttonPanel.getCancelButton().addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent event) {
					cancel();
				}
			});
		}
	}
		
	public boolean isNewForm() {
		return formType == EditFormType.New || formType == EditFormType.Dialog;
	}

	@Override
	void drawDataProperty(EIEntity propertyEntity, Set<String> propertyValues) {
		if (propertyEntity == DatatoolsUIConstants.propertyName) {
			formPanel.add(TextWidget.makeLabelTextWidget(eiInstance, propertyEntity, propertyValues.iterator().next()));
		} 
		else if (propertyValues == null || propertyValues.size() == 0) 
		{
			if(booleanPropEntityList.contains(propertyEntity)) {
				formPanel.add(WidgetUtils.createRadioButon(eiInstance, propertyEntity, null));
			} else {
				formPanel.add(new EditWidgetCollection(eiInstance, propertyEntity, TextWidget.makeDatatypeTextWidget(eiInstance, propertyEntity, null)));
			}
		}
		else {
			EditWidgetCollection fields = new EditWidgetCollection(eiInstance, propertyEntity);
			for(String value:propertyValues) {
				if(booleanPropEntityList.contains(propertyEntity)) {
					fields.addWithoutModifiers(WidgetUtils.createRadioButon(eiInstance, propertyEntity, value));
				} else {
					fields.addWidget(TextWidget.makeDatatypeTextWidget(eiInstance, propertyEntity, value));
				}
			}
			formPanel.add(fields);
		}
		
	}

	@Override
	void drawNonOntologyLiteralProperty(EIEntity propertyEntity,Set<String> propertyValues, Map<EIEntity, String> labelMap,	VerticalPanel nonOntologyPanel) {
		if(!propertyEntity.getURI().toString().equals(WorkFlowConstants.COMMENTS) && !propertyEntity.getURI().toString().equals(WorkFlowConstants.CURATOR_NOTE)) {
			EditWidgetCollection fields = new EditWidgetCollection(eiInstance, propertyEntity);
			nonOntologyPanel.add(fields); 
			for(String value:propertyValues) {
				fields.addWidget(TextWidget.makeNonOntologyTextWidget(eiInstance, propertyEntity, value));
			}
		}
		
	}

	@Override
	void drawNonOntologyResourceProperty(EIEntity propertyEntity,Set<EIEntity> propertyValues, Map<EIEntity, String> labelMap,
				VerticalPanel nonOntologyPanel) {
		EditWidgetCollection fields = new EditWidgetCollection(eiInstance, propertyEntity);
		nonOntologyPanel.add(fields);
		for(EIEntity value : propertyValues) {
			fields.addWidget(TextWidget.makeNonOntologyTextWidget(eiInstance, propertyEntity, value.getLabel()));
		}
		
	}

	@Override
	void drawObjectProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues) {
		
		if(propertyEntity.getLabel().equals("Type")) { // Type does not have a range
			drawTypeProperty();
		} else if(objectProperties.get(propertyEntity) != null && objectProperties.get(propertyEntity).size() > 0){
			EditWidgetCollection fields = new EditWidgetCollection(eiInstance, propertyEntity);
			formPanel.add(fields);
			
			if(objectProperties.get(propertyEntity).size()==1) { //Single range
				drawSingleObjectProperty(propertyEntity, propertyValues, fields);
			} else { // Multiple ranges
				Log.info(propertyEntity + " is a multi-range item  with " + (propertyValues == null ? "<null>" : propertyValues.size()) + "entries" );
				if (propertyValues == null || propertyValues.size() == 0) {
					createWidgetForMultiRanges(propertyEntity, null, fields);
				}
				else {
					for(EIEntity selectedEntity:propertyValues) {
						createWidgetForMultiRanges(propertyEntity, selectedEntity, fields);
					}
				}
			}
		}
	}

	private void drawSingleObjectProperty(EIEntity propertyEntity, Set<EIEntity> propertyValues, EditWidgetCollection fields) {
		EIClass range = objectProperties.get(propertyEntity).iterator().next();
		if (hasLabUri() && WidgetUtils.isLabProperty(range)) {
			Log.info("making disabled widget for lab uri '" + labEntity + "' property " + range.getEntity().getLabel());
			eiInstance.addObjectProperty(propertyEntity, labEntity);
			createWidgetForRange(propertyEntity, range, labEntity.getURI().toString(), fields, true);					
		}
		else if (propertyValues == null || propertyValues.size() == 0) { // new 
			if (WidgetUtils.isLabProperty(range))
				Log.info("drawing widget for lab prop " + range.getEntity().getLabel() + " without treating it as lab");
			createWidgetForRange(propertyEntity, range, "", fields, false);
		}
		else { // existing
			if (WidgetUtils.isLabProperty(range))
				Log.info("drawing multiple widgets for lab prop " + range.getEntity().getLabel() + " without treating it as lab");
			
			for(EIEntity selectedEntity:propertyValues) {
				// TODO: MUST use Entity not URI.toString()
				createWidgetForRange(propertyEntity, range, selectedEntity.getURI().toString(), fields, false);
			}
		}
	}

	private void drawTypeProperty() {
		final HorizontalPanel temp = new HorizontalPanel();
		formPanel.add(temp);
		if (WidgetUtils.isLabProperty(eiInstance.getInstanceClass())) {
			final EIClass superclass = eiInstance.getInstanceClass();
			TypeWidget typeWidget = new TypeWidget(eiInstance, null, superclass, eiInstance.getInstanceClass(), new TypeWidget.TypeChangeHandler() {
				@Override
				public void onTypeChange() {
					Log.info("redrawing; type changed to " + eiInstance.getInstanceClass());
					formPanel.clear();
					formPanel.add(buttonPanel);
					eiClass = eiInstance.getInstanceClass();
					initializePropertyLists(); // re-gets lists, re-draws form.  Also adds as a session listener *again*
				}			
			});
			temp.add(typeWidget);
		} else {
			ClientOntologyToolsManager.INSTANCE.getRootSuperClass(eiInstance.getInstanceClass(), new EISuperClassCallback() {				
				@Override
				public void onSuccess(final EIClass superclass) {
					TypeWidget typeWidget = new TypeWidget(eiInstance, null, superclass, eiInstance.getInstanceClass(), new TypeWidget.TypeChangeHandler() {
						@Override
						public void onTypeChange() {
							Log.info("redrawing; type changed to " + eiInstance.getInstanceClass());
							formPanel.clear();
							formPanel.add(buttonPanel);
							eiClass = eiInstance.getInstanceClass();
							initializePropertyLists(); // re-gets lists, re-draws form.  Also adds as a session listener *again*
						}			
					});
					temp.add(typeWidget);
				}
			});
		}
	}
 
	private void createWidgetForMultiRanges(EIEntity propertyEntity, EIEntity selectedEntity, final EditWidgetCollection fields) {
		
		Log.info("making multi-range widget with " + objectProperties.get(propertyEntity).size() + " ranges");
		ObjectWidget widget = new ObjectWidget(eiInstance, propertyEntity, objectProperties.get(propertyEntity), labEntity, selectedEntity);
		fields.addWidget(widget, widget.isDisabled());
	}

	private void createWidgetForRange(final EIEntity propertyEntity, final EIClass range, String selectedUriString, final EditWidgetCollection fields, final boolean isLab) {
		if(range.isEagleIResource()) {				
			EIResourceWidget resourceWidget = new EIResourceWidget(eiInstance, propertyEntity, range, selectedUriString, true);
			fields.addWidget(resourceWidget, isLab);
			if (isLab) 
				resourceWidget.disable();
		} else {
			WidgetUtils.addTermWidgetToPanel(eiInstance, propertyEntity, range, selectedUriString, fields, true);		
		}
	}

	@Override
	public void onLogIn(String username, String userUri) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onLogOut() {
		// TODO Auto-generated method stub
		
	}

	@Override
	Collection<EIEntity> getDataTypeEntities() {
		return dataPropEntityList;
	}

	@Override
	Collection<EIEntity> getNonOntologyLiteralPropEntities() {
		return eiInstance.getNonOntologyLiteralProperties().keySet();
	}

	@Override
	Collection<EIEntity> getNonOntologyResourcePropEntities() {
		return eiInstance.getNonOntologyResourceProperties().keySet();
	}

	@Override
	Collection<EIEntity> getObjectTypeEntities() {
		return objPropEntityList;
	}
	
	@Override
	protected void drawExtraFields(Map<EIEntity, Set<String>> nonOntologyLiteralProperties) {
		EIEntity comments = EIEntity.create(WorkFlowConstants.COMMENTS, WorkFlowConstants.COMMENTS_LABEL);
		EIEntity curatorComments = EIEntity.create(WorkFlowConstants.CURATOR_NOTE, WorkFlowConstants.CURATOR_LABEL);
		
		String commentValue = nonOntologyLiteralProperties.containsKey(comments) ? nonOntologyLiteralProperties.get(comments).iterator().next() : null;
		TextAreaWidget commentsArea = new TextAreaWidget(eiInstance, comments, commentValue);
		formPanel.add(commentsArea);
		
		String curatorValue = nonOntologyLiteralProperties.containsKey(curatorComments) ? nonOntologyLiteralProperties.get(curatorComments).iterator().next() : null;
		TextAreaWidget curatorArea = new TextAreaWidget(eiInstance, curatorComments, curatorValue);
		formPanel.add(curatorArea);
	}
	
	private void initializePropertyLists() {
		dataPropEntityList.clear();
		objPropEntityList.clear();
		objectProperties.clear();
		booleanPropEntityList.clear();
		
		ClientOntologyToolsManager.INSTANCE.getProperties(eiClass, new PropertyCallback() {
			@Override
			public void onSuccess(EIClass result) {
				for (EIProperty property : result.getProperties()) {
					if (property instanceof EIDatatypeProperty) {
						dataPropEntityList.add(property.getEntity());
						if (((EIDatatypeProperty) property).getTypeLabel().equals("boolean")) {
							booleanPropEntityList.add(property.getEntity());
						}
					}
					else if (property instanceof EIObjectProperty) {
						objPropEntityList.add(property.getEntity());
						objectProperties.put(property.getEntity(), ((EIObjectProperty) property).getRangeList());
					}
				} 
				finishSetup();
			}
		});
	}
	
	// TODO: make a static on WidgetUtils
	protected boolean hasLabUri() {
		return (labEntity != null) && (! labEntity.getURI().toString().equals(""));
	}
	
	protected void save() { // TODO: handle stale token correctly
		try {
			if (eiInstance.getInstanceLabel()==null || eiInstance.getInstanceLabel().trim().equals(""))
			{
				Window.alert(WorkFlowConstants.LABEL_REQUIRED);
				return;
			}
			
			if (isNewForm()) { 
				saveNewForm();
			}
			else {
				ClientRepositoryToolsManager.INSTANCE.updateInstance(eiInstance, editToken, new ResultsCallback() {
					@Override
					public void onSuccess(String str) {
						formRedisplayCallbacks.drawAfterSave(eiInstance);
					}
					@Override
					public void loginRequired() {
						Window.alert(WorkFlowConstants.PLEASE_LOGIN);
					}
					@Override
					public void onSuccess(String[] arg0) {
						formRedisplayCallbacks.drawAfterSave(eiInstance);
					}
				});
			}
		} catch (Exception e) {
			Log.error("could not (re-) get instance");
		}
	}
	
	private void saveNewForm() throws Exception {
		ClientRepositoryToolsManager.INSTANCE.createInstance(eiInstance, new EIInstanceCallback() {
			@Override
			public void onSuccess(EIInstance saved) {
				Log.info("drawing " + saved.getInstanceLabel() + " after saving");
				formRedisplayCallbacks.drawAfterSave(saved); 
			}
			@Override
			public void loginRequired() {
				Window.alert(WorkFlowConstants.PLEASE_LOGIN);
			}
		});
		
	}
	
	private void cancel() {
		try {
			if (formType == EditFormType.New) {
				Log.error("Cancel button should not be visible on new form!");
			} else if (formType == EditFormType.Dialog) {
				formRedisplayCallbacks.drawAfterCancel(eiInstance);
			}
			else {
				ClientRepositoryToolsManager.INSTANCE.getInstance(eiInstance.getInstanceURI(), new EIInstanceCallback() {
					@Override
					public void loginRequired() {
						
					}
					
					@Override
					public void onSuccess(EIInstance fetched) {
						formRedisplayCallbacks.drawAfterCancel(fetched);
					}
				});
			}
		} catch (Exception e) {
			Log.error("could not get instance");
		}
	}

	@Override
	void setButtonState() {
		buttonPanel.saveButton.setVisible(true);
		if (formType == EditFormType.New) {
			buttonPanel.copyResourceButton.setVisible(false);
			buttonPanel.cancelButton.setVisible(false);
		} else if (formType == EditFormType.Dialog) {
			buttonPanel.copyResourceButton.setVisible(false);
			buttonPanel.cancelButton.setVisible(true);
		}
		else {
			buttonPanel.copyResourceButton.setVisible(true);
			buttonPanel.cancelButton.setVisible(true);
		}
			
		buttonPanel.editButton.setVisible(false);
	}
	
	private void getEditToken() {
		try {
			ClientRepositoryToolsManager.INSTANCE.updateInstance(eiInstance, null, new ResultsCallback() {
				@Override
				public void loginRequired() {
					Window.alert(WorkFlowConstants.PLEASE_LOGIN);
				}
				@Override
				public void onSuccess(String[] arg0) {
				}
				@Override
				public void onSuccess(String arg0) {
					editToken = arg0;
				}
			});
		} catch (Exception e) {
			Log.error("failed to get edit token for " + eiInstance);
			Window.alert(WorkFlowConstants.NO_TOKEN_AVAILABLE);
		}
	}
}
