package org.eaglei.datatools.client.ui;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;

public abstract class EditWidget extends Composite {
	protected HorizontalPanel widgetPanel = new HorizontalPanel();
	
	protected EIInstance eiInstance;
	protected EIEntity propertyEntity;
	protected String oldValue;
	protected boolean shouldShowLabel;
	protected Label label;
	protected final String name;
	
	EditWidget(EIInstance eiInstance, EIEntity propertyEntity) {
		initWidget(widgetPanel);
		this.name = propertyEntity.getURI().toString();
		this.eiInstance = eiInstance;
		this.propertyEntity = propertyEntity;
		label = WidgetUtils.createLabel(propertyEntity);
		widgetPanel.add(label);
	}
	
	protected void setLabelContents(String newContents) {
		Log.info("setting label contents to " + newContents);
		label.setText(newContents);
	}
	
	protected void updateOldValue(String oldValue) {
		this.oldValue = oldValue;
	}
	
	protected void updateOldValue(EIURI oldValue) {
		this.oldValue = oldValue.toString();
	}
	
	protected abstract void removeValue();
	
	public abstract EditWidget duplicateBlank();
	
	protected EIURI getOldEIURIValue() {
		return EIURI.create(oldValue);
	}
	
	protected String getOldStringValue() {
		return oldValue;
	}
	
	protected boolean hasOldValue() {
		return oldValue!=null && !"".equals(oldValue);
	}
	
	public boolean shouldShowLabel() {
		return shouldShowLabel;
	}
	
	protected String getLabel() {
		return propertyEntity.getLabel();
	}

	public void setShouldShowLabel(boolean shouldShowLabel) {
		this.shouldShowLabel = shouldShowLabel;
		if(! shouldShowLabel) {
		
			Log.info("blanking label");
			setLabelContents("");
		}
		else {
			setLabelContents(getLabel());
		}
	}
	
	public String getName() {
		return name;
	}
}
