package org.eaglei.datatools.client.ui;

import java.util.List;

import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstancesCallback;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.suggest.client.SharedClassChooser;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;

import com.allen_sauer.gwt.log.client.Log;

public class FilterPanel extends Composite {
	interface Binder extends UiBinder<Widget, FilterPanel> {
	}
	private static final Binder				binder		= GWT.create(Binder.class);
	@UiField
	HorizontalPanel							subTypeFilter;
	@UiField
	ListBox									statusFilter;
	@UiField
	ListBox									resourceTypeFilter;
	@UiField
	ListBox									labFilter;
	@UiField
	Label									statusLabel;
	@UiField
	Label									labLabel;
	@UiField
	Label									resourceTypeLabel;
	@UiField
	Label									filterLabel;
	@UiField
	Label									totalResources;
	@UiField
	Button	goButton;
	
	WorkFlowConstants						workFlowConstants;
	FormsPanel								formsPanel	= new FormsPanel();
	private String							wfState;
	private String							tokenBeforeEdit;
	private MainPanel						mainPanel;
	SharedClassChooser<OntologyDropdown>	classChooser;
	public MainPanel getMainPanel() {
		return mainPanel;
	}
	public void setMainPanel(MainPanel mainPanel) {
		this.mainPanel = mainPanel;
	}
	public FilterPanel() {
	}
	public SharedClassChooser<OntologyDropdown> getClassChooser() {
		return classChooser;
	}
	public void setClassChooser(SharedClassChooser<OntologyDropdown> classChooser) {
		this.classChooser = classChooser;
	}
	public FilterPanel(String instanceWFState) {
		this(instanceWFState, false);
	}
	public FilterPanel(String instanceWFState, boolean instanceHasOwner) {
		initWidget(binder.createAndBindUi(this));
		workFlowConstants = new WorkFlowConstants();
		this.wfState = instanceWFState;
		Log.info("filter wfstate: " + wfState);
		/*setButtonState(saveButton);
		setTransitionButtonState(curationButton, WorkFlowConstants.CURATION_STATE); // possible to send to curation if you can edit drafts
		setTransitionButtonState(publishButton, WorkFlowConstants.PUBLISH_STATE); // possible to publish if you can edit curation
		setTransitionButtonState(backToDraftButton, WorkFlowConstants.DRAFT_STATE); // possible to return to draft if you can edit curation
		setTransitionButtonState(withdrawButton, WorkFlowConstants.WITHDRAW_STATE);
		if (claimRequired(instanceHasOwner)) {
			disable(editButton);
			disable(publishButton);
			disable(backToDraftButton);
		} else {
			setButtonState(editButton, instanceWFState);
		}
		setButtonState(copyResourceButton);
		cancelButton.setVisible(false);*/
		subTypeFilter.setVisible(false);
		statusFilter.setVisible(false);
		filterLabel.setVisible(false);
		statusLabel.setVisible(false);
		//goButton.setVisible(false);
		resourceTypeLabel.setVisible(false);
		resourceTypeFilter.setVisible(false);
		labFilter.setVisible(false);
		labLabel.setVisible(false);
		/*saveButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				try {
					//	History.newItem("save");
					MainPanel.saveForm();
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		});
		curationButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				try {
					MainPanel.sendToCuration();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
		publishButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				try {
					MainPanel.publish();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
		backToDraftButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				try {
					MainPanel.returnToDraft();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
		withdrawButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				try {
					MainPanel.withdraw();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
		copyResourceButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				try {
					History.newItem("copy");
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
		editButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				
				 * if (!History.getToken().contains("save")) {
				 * Datatools.mainPanel.setTokenBeforeEdit(History.getToken()); }
				 
				
			//	History.newItem("edit&" + cell.getRowIndex(), false);
			//	Datatools.mainPanel.doEditGrid(cell.getRowIndex());
				History.newItem("editresource" + "&" + MainPanel.instanceUri,false);
				MainPanel.editResource();
			}
		});
		cancelButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				//	History.newItem(Datatools.mainPanel.getTokenBeforeEdit());
			Datatools.mainPanel.listPanel.frmPanel.viewAfterSave(false);
			}
		});*/
	}
	public FilterPanel(String labSelected, SharedClassChooser<OntologyDropdown> chooser) {
		initWidget(binder.createAndBindUi(this));
		this.classChooser = chooser;
		if (classChooser != null) {
			this.subTypeFilter.add(classChooser);
			resourceTypeLabel.setVisible(false);
			resourceTypeFilter.setVisible(false);
		}
		populateStatusFilter();
		populateResourceTypeFilter();
		populateLabFilter();
		subTypeFilter.setVisible(true);
		statusFilter.setVisible(true);
		filterLabel.setVisible(true);
		statusLabel.setVisible(true);
		goButton.setVisible(true);
		checkTokenAndSetVisibilityForLab();
	}
	private void checkTokenAndSetVisibilityForLab() {
		if (History.getToken().contains("mylaboratories")) {
			labLabel.setVisible(false);
			labFilter.setVisible(false);
		}
	}
	private void populateStatusFilter() {
		statusFilter.addItem("All States");
		statusFilter.addItem(WorkFlowConstants.DRAFT_STATE);
		statusFilter.addItem(WorkFlowConstants.CURATION_STATE);
		statusFilter.addItem(WorkFlowConstants.PUBLISH_STATE);
		statusFilter.addItem(WorkFlowConstants.WITHDRAW_STATE);
	}
	private void populateResourceTypeFilter() {
		resourceTypeFilter.addItem("All Resources");
		for (EIClass eiclass : LeftListPanel.resourceTypes) {
			resourceTypeFilter.addItem(eiclass.getEntity().getLabel(), eiclass.getEntity().getURI().toString());
		}
	}
	private void populateLabFilter() {
		labFilter.addItem("All Laboratories");
		// Populate the list only when clicked
		labFilter.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent arg0) {
				if (labFilter.getItemCount() == 1) { // Populate the list only
					// if it is not already
					// populated
					labFilter.addItem("List is loading....");
					ClientRepositoryToolsManager.INSTANCE.getResourcesOfClass(MainPanel.userUri, EIURI.create("http://purl.obolibrary.org/obo/ERO_0000001"), new EIInstancesCallback() {
						@Override
						public void onSuccess(final List<EIInstance> eiInstanceList) {
							labFilter.removeItem(labFilter.getItemCount() - 1);
							for (EIInstance instance : eiInstanceList) {
								labFilter.addItem(instance.getInstanceLabel(), instance.getInstanceURI().toString());
							}
						}
						@Override
						public void loginRequired() {
						}
					});
				}
			}
		});
	}
	private void setButtonState(Button workflowButton, String workflowConstantState) {
		// Note: "previous" state refers to the name of the button--only enable
		// if the state associated with the button is
		// the same as the state of the resource, since we call the button with
		// the name of the state that can promote to it
		workflowButton.setVisible(true);
		if (ClientRepositoryToolsManager.INSTANCE.canEdit(workflowConstantState)) {
			workflowButton.setEnabled(true);
		} else {
			disable(workflowButton);
		}
	}
	private void setButtonState(Button workflowButton) {
		workflowButton.setVisible(true);
		if (ClientRepositoryToolsManager.INSTANCE.getEditableStates().size() == 0) {
			disable(workflowButton);
		}
	}
	private void setTransitionButtonState(Button workflowButton, String workflowConstantState) {
		// Note: "previous" state refers to the name of the button--only enable
		// if the state associated with the button is
		// the same as the state of the resource, since we call the button with
		// the name of the state that can promote to it
		workflowButton.setVisible(true);
		if (Datatools.canUserChangeState(wfState, workflowConstantState)) {
			workflowButton.setEnabled(true);
		} else {
			disable(workflowButton);
		}
	}
	private void disable(Button workflowButton) {
		workflowButton.setEnabled(false);
		workflowButton.addStyleName("btnDisabled"); 
	}
	public void changeDisplayAccordingToView(String token) {
		if (token.matches("myResources")) {
			resourceTypeFilter.setVisible(true);
			subTypeFilter.setVisible(false);
			resourceTypeLabel.setVisible(true);
			statusFilter.setVisible(true);
			filterLabel.setVisible(true);
			statusLabel.setVisible(true);
			goButton.setVisible(true);
//			wfLabel.setVisible(false);
			//formControlLabel.setVisible(false);
		} else if (token.matches("myResources/.*?$")) {
			resourceTypeLabel.setVisible(false);
			resourceTypeFilter.setVisible(false);
			if (classChooser != null) {
				subTypeFilter.setVisible(true);
				subTypeFilter.add(classChooser);
			}
			statusFilter.setVisible(true);
			filterLabel.setVisible(true);
			statusLabel.setVisible(true);
			goButton.setVisible(true);
//			wfLabel.setVisible(false);
			//formControlLabel.setVisible(false);
		} else if (token.contains("myLaboratories")) {
			subTypeFilter.setVisible(true);
			/*curationButton.setVisible(false);
			saveButton.setVisible(false);
			editButton.setVisible(false);
			cancelButton.setVisible(false);
			publishButton.setVisible(false);
			copyResourceButton.setVisible(false);
			backToDraftButton.setVisible(false);
			withdrawButton.setVisible(false);*/
			statusFilter.setVisible(true);
			filterLabel.setVisible(true);
			statusLabel.setVisible(true);
			goButton.setVisible(true);
//			wfLabel.setVisible(false);
			//formControlLabel.setVisible(false);
		}
	}
	private boolean claimRequired(boolean hasOwner) {
		if (wfState.equals(WorkFlowConstants.WITHDRAW_STATE) || WorkFlowConstants.WITHDRAW_STATE.equals(new WorkFlowConstants().getStatusType(wfState)) || wfState.equals(WorkFlowConstants.PUBLISH_STATE) || WorkFlowConstants.PUBLISH_STATE.equals(new WorkFlowConstants().getStatusType(wfState)))
			return false;
		return !hasOwner;
	}
}
