package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.datatools.client.ui.EditFormsPanel.EditFormType;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * Creates a Form Panel. This is a common class for Labs & Resources
 * 
 * @author pp101
 * 
 */
public class FormsPanel {
	private EIInstance		eiInstance;
	private boolean			signedIn	= false;
	
	private EIFormsPanel formsPanel;
	
	public FormsPanel() {
		
	}
	/**
	 * Generates a new form based on the URI passed.
	 * 
	 * @return
	 */
	public VerticalPanel generateNewForm(final EIURI eiURI) {
		return generateNewForm(eiURI, false, getNewFormRedisplay());
	}

	public VerticalPanel generateNewForm(final EIURI eiURI, final boolean isDialog, final EditFormRedisplay redisplay) {
		final VerticalPanel vp = new VerticalPanel();
		
		ClientRepositoryToolsManager.INSTANCE.getEmptyEIInstance(eiURI, new EIInstanceCallback() {
			@Override
			public void onSuccess(EIInstance newInstance) {
				EIClass resourceClass = newInstance.getInstanceClass();
				Log.info("Class from new empty instance was " + resourceClass);
				if (isDialog)
					formsPanel = EditFormsPanel.createDialogForm(newInstance, resourceClass, MainPanel.labUri, redisplay);
				else
					formsPanel = EditFormsPanel.createNewForm(newInstance, resourceClass, MainPanel.labUri, redisplay);
				vp.add(formsPanel);
			}
			@Override
			public void loginRequired() {
				handleLoginRequired();			
			}
			
		});
		return vp;
	}
	
	/**
	 * This method creates a form to edit. The values of fields will be
	 * prepopulated.
	 * 
	 * @param eiuri
	 * @return
	 */
	public void generateEditForm(EIInstance instance) {
		Log.info("generating edit form from instance");
		generateEditContents(instance);
	}
	
	public VerticalPanel generateDuplicateForm(EIInstance instance) {
		Log.info("generating new form from (duplicated) instance");
		final VerticalPanel vp = new VerticalPanel();
		vp.setStyleName("formPanel");
		formsPanel = EditFormsPanel.createNewForm(instance, instance.getInstanceClass(), MainPanel.labUri, getNewFormRedisplay());
		vp.add(formsPanel);
		return vp;
	}
	
	public VerticalPanel generateEditForm(String eiuri) {
		Log.info("generating edit form from uri");
		final VerticalPanel vp = new VerticalPanel();
		vp.setStyleName("formPanel");
		EIURI uri = EIURI.create(eiuri);
		try {
			ClientRepositoryToolsManager.INSTANCE.getInstance(uri, new EIInstanceCallback() {
				@Override
				public void onSuccess(final EIInstance instance) {
					generateEditContents(instance);
				}
				
				@Override
				public void loginRequired() {
					handleLoginRequired();
				}
			});
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return vp; 
	}
	
	private void generateEditContents(final EIInstance instance) {
		Log.info("generating edit contents");
		
		formsPanel = EditFormsPanel.createEditForm(instance, instance.getInstanceClass(), MainPanel.labUri, getEditFormRedisplay());
		MainPanel.dataPanel.add(formsPanel);
	}
	
	/**
	 * This method creates a form in 'view' mode. The fields are not editable
	 * 
	 * @param eiuri
	 * @return
	 */
	public VerticalPanel generateViewForm(final EIInstance instance) {
		final VerticalPanel vp = new VerticalPanel();
		vp.setStyleName("formPanel");
		if (instance.getInstanceType().getLabel().equalsIgnoreCase("laboratory")) {
			MainPanel.labUri = instance.getInstanceURI();
		}
		formsPanel = new ViewFormsPanel(instance, getViewFormRedisplay());
		vp.add(formsPanel);
		
		return vp;
	}
	
	public void setLoggedOut() {
	}
	
	private void handleLoginRequired() {
		// TODO: what's the real behavior?
		Window.alert(WorkFlowConstants.PLEASE_LOGIN);
		//setLoggedOut();
	}
	
	protected EditFormRedisplay getEditFormRedisplay() {
		return new EditFormRedisplay() {
			
			@Override
			public void drawAfterSave(EIInstance instance) {
				MainPanel.dataPanel.clear();
				HTML msg = new HTML("<font color='green'>" + WorkFlowConstants.SAVE_SUCCESS + "</font>");
				MainPanel.dataPanel.add(msg);
				try {
					ClientRepositoryToolsManager.INSTANCE.getInstance(instance.getInstanceURI(), new EIInstanceCallback() {
						@Override
						public void onSuccess(EIInstance fetchedInstance) {
							viewAfterUpdate(fetchedInstance);
						}
						@Override
						public void loginRequired() {
							handleLoginRequired();
						}
					});
				} catch (Exception e) {
					Log.error("could not (re-) get instance");
				}
			}
			
			@Override
			public void drawAfterPromote(final EIInstance instance) {
				MainPanel.dataPanel.clear();
				try {
					ClientRepositoryToolsManager.INSTANCE.getInstance(instance.getInstanceURI(), new EIInstanceCallback() {
						@Override
						public void onSuccess(EIInstance fetchedInstance) {
							generateEditForm(fetchedInstance);
						}
						@Override
						public void loginRequired() {
							handleLoginRequired();
						}
					});
				} catch (Exception e) {
					Log.error("could not (re-) get instance");
				}
			}
			
			@Override
			public void drawAfterCancel(EIInstance instance) {
				MainPanel.dataPanel.clear();
				try {
					ClientRepositoryToolsManager.INSTANCE.getInstance(instance.getInstanceURI(), new EIInstanceCallback() {
						@Override
						public void onSuccess(EIInstance fetchedInstance) {
							viewAfterUpdate(fetchedInstance);
						}
						@Override
						public void loginRequired() {
							handleLoginRequired();
						}
					});
				} catch (Exception e) {
					Log.error("could not (re-) get instance");
				}
				
			}

			@Override
			public void drawAfterDuplicate(EIInstance instance) {
				MainPanel.dataPanel.clear();
				MainPanel.copyResource(instance.getInstanceURI());
			}
		};
	}
	
	protected ViewFormRedisplay getViewFormRedisplay() {
		return new ViewFormRedisplay() {
			
			@Override
			public void drawAfterPromote(EIInstance instance) {
				MainPanel.dataPanel.clear();
				try {
					ClientRepositoryToolsManager.INSTANCE.getInstance(instance.getInstanceURI(), new EIInstanceCallback() {
						@Override
						public void onSuccess(EIInstance fetchedInstance) {
							MainPanel.dataPanel.add(generateViewForm(fetchedInstance));
						}
						@Override
						public void loginRequired() {
							handleLoginRequired();
						}
					});
				} catch (Exception e) {
					Log.error("could not (re-) get instance");
				}
			}
			
			@Override
			public void drawAfterDuplicate(EIInstance instance) {
				MainPanel.dataPanel.clear();
				MainPanel.copyResource(instance.getInstanceURI());
			}

			@Override
			public void drawEdit(EIInstance instance) {
				MainPanel.dataPanel.clear();
				generateEditForm(instance);
			}
		};
	}
	
	protected EditFormRedisplay getNewFormRedisplay() {
		return new EditFormRedisplay() {
			
			@Override
			public void drawAfterSave(EIInstance instance) {
				MainPanel.dataPanel.clear();
				HTML msg = new HTML("<font color='green'>" + WorkFlowConstants.SAVE_SUCCESS + "</font>");
				MainPanel.dataPanel.add(msg);
				try {
					ClientRepositoryToolsManager.INSTANCE.getInstance(instance.getInstanceURI(), new EIInstanceCallback() {
						@Override
						public void onSuccess(EIInstance fetched) {
							MainPanel.instanceUri = fetched.getInstanceURI().toString();
							MainPanel.dataPanel.add(generateViewForm(fetched));
						}
						@Override
						public void loginRequired() {
							handleLoginRequired();
						}
					});
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
			}
			
			@Override
			public void drawAfterPromote(EIInstance instance) {
				Window.alert("Cannot promote an unsaved new instance");
			}
			
			@Override
			public void drawAfterCancel(EIInstance instance) {
				Window.alert("shouldn't get here (I think)");
			}

			@Override
			public void drawAfterDuplicate(EIInstance instance) {
				MainPanel.dataPanel.clear();
				MainPanel.copyResource(instance.getInstanceURI());
			}
		};
	}
	
	public static String getWFStateString(final EIInstance instance) {
		return instance.getWFState() == null ? "" : instance.getWFState().getURI().toString();
	}
	@Deprecated
	public EIInstance getEiInstance() {
		return eiInstance;
	}
	
	public boolean isSignedIn() {
		return signedIn;
	}
	public void setSignedIn(boolean signedIn) {
		this.signedIn = signedIn;
	}
	
	public void viewAfterSave(boolean showSuccessMsg, EIInstance instance) {
		MainPanel.dataPanel.clear();
		if(showSuccessMsg)
		{
			HTML msg = new HTML("<font color='green'>" + WorkFlowConstants.SAVE_SUCCESS + "</font>");
			MainPanel.dataPanel.add(msg);	
		}
		
		MainPanel.dataPanel.add(generateViewForm(instance));
		MainPanel.instanceUri = instance.getInstanceURI().toString();
	}
	
	public void viewAfterUpdate(EIInstance fetchedInstance) {
		MainPanel.dataPanel.add(generateViewForm(fetchedInstance));
	}
}
