package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.client.Datatools;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;

public class HistoryRootPanel {
	public static enum Action {
		lose_visibilty, get_visibility, focus, blur, filltext_with_partoftokenStingprecededbycolon, popup, hidepopup
	};
	private static HistoryRootPanel	historymanager;
	public static HistoryRootPanel getInstance() {
		if (historymanager == null) {
			historymanager = new HistoryRootPanel();
		}
		return historymanager;
	}
	/**
	 * add the valuechange event handlers and deligates it to changeDisplayToken
	 */
	private HistoryRootPanel() {
		History.addValueChangeHandler(new ValueChangeHandler<String>() {
			public void onValueChange(ValueChangeEvent<String> event) {
				changeDisplayByToken(event.getValue(), false);
			}
		});
	}
	/**
	 * all the logic of transistion when back and forward buttons are pressed
	 * happens here
	 * 
	 * @param token
	 */
	public void changeDisplayByToken(String token, boolean isRefreshed) {
		if (token.toLowerCase().contains("mylaboratories")) {
			if (token.toLowerCase().equals("mylaboratories"))
				MainPanel.listPanel.doLabs();
			else {
				String[] tokenSplit = token.split("=");
				if (tokenSplit[1].matches("\\d+&\\d+&.*?$")) {
					String[] cellIndexAry = tokenSplit[1].split("&");
					Datatools.mainPanel.doLabTable(Integer.parseInt(cellIndexAry[0]), Integer.parseInt(cellIndexAry[1]), cellIndexAry[2]);
					if (tokenSplit.length < 2) {
						String[] filterString = tokenSplit[2].split("&");
						Datatools.mainPanel.doFilterPanelGoButton(filterString[0], filterString[1], filterString[3]);
					}
				} else {
					String[] filterString = tokenSplit[1].split("&");
					if (Datatools.isRefresh)
						Datatools.mainPanel.doFilterPanelGoButtonWhenRefresh(filterString[0], filterString[1], filterString[2]);
					else
						Datatools.mainPanel.doFilterPanelGoButton(filterString[0], filterString[1], filterString[2]);
				}
			}
		} else if (token.toLowerCase().contains("myresources")) {
			if (token.toLowerCase().equals("myresources"))
				MainPanel.listPanel.doResources();
			else {
				String[] tokenSplit = token.split("=");
				if (tokenSplit[1].matches("\\d+&\\d+")) {
					String[] cellIndexAry = tokenSplit[1].split("&");
					Datatools.mainPanel.doSubLinksOfResource(Integer.parseInt(cellIndexAry[0]), Integer.parseInt(cellIndexAry[1]));
					if (tokenSplit.length < 2) {
						String[] filterString = tokenSplit[2].split("&");
						Datatools.mainPanel.doFilterPanelGoButton(filterString[0], filterString[1], filterString[3]);
					}
				} else {
					String[] filterString = tokenSplit[1].split("&");
					if (Datatools.isRefresh)
						Datatools.mainPanel.doFilterPanelGoButtonWhenRefresh(filterString[0], filterString[1], filterString[2]);
					else
						Datatools.mainPanel.doFilterPanelGoButton(filterString[0], filterString[1], filterString[2]);
				}
			}
		} else if (token.toLowerCase().equals("addnewlablink")) {
			MainPanel.listPanel.doAddNewLabLink();
		} else if (token.toLowerCase().contains("edit&")) {
			Datatools.mainPanel.doEditGrid(Integer.parseInt(token.split("&")[1]));
		} else if (token.toLowerCase().contains("delete&")) {
			Datatools.mainPanel.doDeleteGrid(Integer.parseInt(token.split("&")[1]));
		} else if (token.toLowerCase().contains("view&")) {
			extratInstanceuriandSetInMainPanel(token, 2);
			String[] tokenAry = token.split("&");
			Datatools.mainPanel.doViewGrid(Integer.parseInt(tokenAry[1]), tokenAry[tokenAry.length - 1]);
		} else if (token.toLowerCase().contains("claim&")) {
			Datatools.mainPanel.doClaimGrid(Integer.parseInt(token.split("&")[1]));
		} else if (token.toLowerCase().contains("withdraw&")) {
			Datatools.mainPanel.doWithdrawGrid(Integer.parseInt(token.split("&")[1]));
		} else if (token.toLowerCase().contains("save")) {
			//			extratInstanceuriandSetInMainPanel(token, 1);
			//			MainPanel.saveForm();
		} else if (token.toLowerCase().equals("copy")) {
			MainPanel.copyResource();
		} else if (token.toLowerCase().contains("editresource")) {
			extratInstanceuriandSetInMainPanel(token, 1);
			MainPanel.editResource();
		}
	}
	private void extratInstanceuriandSetInMainPanel(String str, int index) {
		MainPanel.instanceUri = str.split("&")[index];
	}
	/**
	 * Similar to page navigation,The token argument should always be the number
	 * indicating index of widget
	 * 
	 * @param Token
	 */
	private void executeRootWidgetTransition(int[] token) {
		int rootPanelWidgetCount = RootPanel.get().getWidgetCount();
		for (int i = 0; i <= rootPanelWidgetCount - 1; i++) {
			Widget wid = RootPanel.get().getWidget(i);
			wid.setVisible(false);
		}
		for (int i = 0; i <= rootPanelWidgetCount - 1; i++) {
			for (int token_int : token) {
				if (i == token_int) {
					Widget wid = RootPanel.get().getWidget(token_int);
					wid.setVisible(true);
				}
			}
		}
	}
	/**
	 * similar to Dhtml transisiton
	 * 
	 * @param Token
	 */
	public void executeInnerWidgetTransition(String token, Action action) {
	}
	
	public void add(Widget w) {
		RootPanel.get("main_container").add(w);
		// addHistoryItem();
	}
}
