package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.DefinitionsCallback;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.TopLevelClassesCallback;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIURI;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;

public class LeftListPanel extends VerticalPanel implements ClientRepositoryToolsManager.SessionListener {
	private boolean				signedIn		= false;
	public static List<EIClass>	resourceTypes;
	public static FlexTable		labsTable		= new FlexTable();
	public static FlexTable		resourcesTable	= new FlexTable();
	public static Anchor		labsLink		= new Anchor();
	public static Anchor		resourcesLink	= new Anchor();
	public static boolean		isLabsLinkSelected;
	final FlowPanel				labsPanel		= new FlowPanel();
	final FlowPanel				resourcesPanel	= new FlowPanel();
	public FilterPanel					filterPanel;
	//public FormsPanel					frmPanel;
	
	public LeftListPanel() {
		Log.info("making left list panel");
		ClientRepositoryToolsManager.INSTANCE.addSessionListener(this);
		signedIn = ClientRepositoryToolsManager.INSTANCE.isLoggedIn();
		if (signedIn)
			getResourceTypes();
		// add(table);
	}
	/**
	 * Retrieves all the top level Resource Categories
	 * 
	 * @return
	 */
	private void getResourceTypes() {
		Log.info("left panel getting resource types");
		ClientOntologyToolsManager.INSTANCE.getTopLevelClasses(new TopLevelClassesCallback() {
			@Override
			public void onSuccess(List<EIClass> classList) {
				Log.info("left list panel got top level classes: " + classList.size());
				resourceTypes = classList;
				createPanel();
				if (Datatools.isRefresh) {
					HistoryRootPanel.getInstance().changeDisplayByToken(Window.Location.getHash().replace("#", ""), Datatools.isRefresh);
				}
			}
		});
	}
	/**
	 * Creates the left panel. If the user is not logged in, it will display the
	 * general view. For a valid user it displays an authenticated view.
	 */
	private void createPanel() {
		Log.info("left list panel creating sub-panel");
		labsLink.setHTML("<b> My Laboratories</b>");
		resourcesLink.setHTML("<b>My Resources</b>");
		setWidth("100");
		setStyleName("leftPanel");
		if (signedIn) {
			Anchor addNewLink = new Anchor("add new");
			addNewLink.setName(DatatoolsUIConstants.EI_LAB +"_add_new");
			labsPanel.add(labsLink);
			labsPanel.add(addNewLink);
			addNewLink.setStyleName("gwt_add_item");
			add(labsPanel);
			add(labsTable);
			labsTable.setVisible(false);
			FlowPanel hp = new FlowPanel();
			HashMap<EIClass, Anchor> mapNoDefClassToUIObject = new HashMap<EIClass, Anchor>();
			Label l = new Label();
			l.setStyleName("tempIcon");
			Anchor r = new Anchor("All Resource Types");
			r.setStyleName("gwt_super_type");
			hp.add(l);
			hp.add(r);
			// Create empty row for setting the selected Lab Name
			labsTable.setText(labsTable.getRowCount(), 0, "");
			labsTable.setText(labsTable.getRowCount() - 1, 1, "");
			labsTable.setWidget(labsTable.getRowCount(), 0, hp);
			labsTable.setWidget(labsTable.getRowCount() - 1, 2, null);
			for(String uri:LabResources.resourcesMap.keySet()) {
				FlowPanel h = new FlowPanel();
				Label i = new Label();
				i.setStyleName("tempIcon");
				Anchor lbl = new Anchor(LabResources.resourcesMap.get(uri));
				lbl.setStyleName("gwt_super_type");
				h.add(i);
				h.add(lbl);
				labsTable.setWidget(labsTable.getRowCount(), 0, h);
				final Anchor a = new Anchor("add new");
				a.setName(uri + "_add_new");
				a.setStyleName("gwt_add_item");
				if (signedIn)
					labsTable.setWidget(labsTable.getRowCount() - 1, 1, a);
				Label uriStr = new Label(uri);
				uriStr.setVisible(false);
				labsTable.setWidget(labsTable.getRowCount() - 1, 2, uriStr);
			}
			setToolTipforClass(mapNoDefClassToUIObject);
			resourcesPanel.add(resourcesLink);
			add(resourcesPanel);
			add(resourcesTable);
			resourcesTable.setVisible(false);
			mapNoDefClassToUIObject.clear();
			for (EIClass eclass : resourceTypes) {
				FlowPanel h = createClassLabel(mapNoDefClassToUIObject, eclass);
				resourcesTable.setWidget(resourcesTable.getRowCount(), 0, h);
				final Anchor a = new Anchor("add new");
				a.setName(eclass.getEntity().getURI().toString() + "_add_new");
				a.setStyleName("gwt_add_item");
				if (signedIn)
					resourcesTable.setWidget(resourcesTable.getRowCount() - 1, 1, a);
				Label uri = new Label(eclass.getEntity().getURI().toString());
				uri.setVisible(false);
				resourcesTable.setWidget(resourcesTable.getRowCount() - 1, 2, uri);
			}
			setToolTipforClass(mapNoDefClassToUIObject);
			// Create New Lab
			addNewLink.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent arg0) {
					History.newItem("addnewlablink",false);
					doAddNewLabLink();
				}
			});
			labsLink.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent arg0) {
					History.newItem("myLaboratories",false);
					doLabs();
				}
			});
			resourcesLink.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent arg0) {
					History.newItem("myResources",false);
					doResources();
				}
			});
		}
	}
	private FlowPanel createClassLabel(HashMap<EIClass, Anchor> mapNoDefClassToUIObject, EIClass eclass) {
		FlowPanel h = new FlowPanel();
		Label i = new Label();
		i.setStyleName("tempIcon");
		Anchor lbl = new Anchor(eclass.getEntity().getLabel());
		lbl.setStyleName("gwt_super_type");
		if (eclass.getDefinition() == null) {
			mapNoDefClassToUIObject.put(eclass, lbl);
		} else
			lbl.setTitle(eclass.getDefinition());
		h.add(i);
		h.add(lbl);
		return h;
	}
	
	private void setToolTipforClass(final Map<EIClass, Anchor> mapNoDefClassToUIObject) {
		final List<EIClass> listNoDefClasses = new ArrayList<EIClass>(mapNoDefClassToUIObject.keySet());
		ClientOntologyToolsManager.INSTANCE.getClassDefinitions(listNoDefClasses, new DefinitionsCallback() {
			@Override
			public void onSuccess(List<EIClass> result) {
				for (EIClass clazz : result) {
					Anchor o = mapNoDefClassToUIObject.get(clazz);
					o.setTitle(clazz.getDefinition());
				}
			}
		});
	}
	@Override
	public void onLogOut() {
		signedIn = false;
		resourceTypes.clear();
		isLabsLinkSelected = false;
		labsPanel.clear();
		resourcesPanel.clear();
		labsTable.clear();
		resourcesTable.clear();
		labsLink = new Anchor();
		resourcesLink = new Anchor();
		clear();
	}
	@Override
	public void onLogIn(String username, String userUri) {
		signedIn = true;
		Log.info("left list panel logging in: about to get resource types");
		getResourceTypes();
		//createPanel();
	}
	public void doResources() {
		isLabsLinkSelected = false;
		LeftListPanel.labsTable.setVisible(false);
		LeftListPanel.resourcesTable.setVisible(true);
		labsPanel.setStyleName("panelNotSelected");
		resourcesPanel.setStyleName("panelSelected");
		for (int i = 0; i < LeftListPanel.resourcesTable.getRowCount(); i++) {
			LeftListPanel.resourcesTable.getRowFormatter().setStyleName(i, "panelNotSelected");
		}
		MainPanel.handleResources();
	}
	public void doLabs() {
		isLabsLinkSelected = true;
		labsPanel.setStyleName("panelSelected");
		resourcesPanel.setStyleName("panelNotSelected");
		resourcesTable.setVisible(false);
		for (int i = 0; i < LeftListPanel.labsTable.getRowCount(); i++) {
			LeftListPanel.labsTable.getRowFormatter().setStyleName(i, "panelNotSelected");
		}
		Datatools.mainPanel.handleLabs();
	}
	public void doAddNewLabLink() {
		labsPanel.setStyleName("panelSelected");
		for (int i = 0; i < LeftListPanel.labsTable.getRowCount(); i++) {
			LeftListPanel.labsTable.getRowFormatter().setStyleName(i, "panelNotSelected");
		}
		for (int i = 0; i < LeftListPanel.resourcesTable.getRowCount(); i++) {
			LeftListPanel.resourcesTable.getRowFormatter().setStyleName(i, "panelNotSelected");
		}
		MainPanel.dataPanel.clear();
		//filterPanel = new FilterPanel("");
		//Log.info("adding filter panel");
		//MainPanel.dataPanel.add(filterPanel);
		//Log.info("added filter panel");
		FormsPanel formsPanel = new FormsPanel();
		MainPanel.dataPanel.add(formsPanel.generateNewForm(EIURI.create("http://purl.obolibrary.org/obo/ERO_0000001")));
	}
	public void doLeftMenuforLabs() {
		isLabsLinkSelected = true;
		labsPanel.setStyleName("panelSelected");
		resourcesPanel.setStyleName("panelNotSelected");
		resourcesTable.setVisible(false);
		labsTable.setVisible(true);
		for (int i = 0; i < LeftListPanel.labsTable.getRowCount(); i++) {
			LeftListPanel.labsTable.getRowFormatter().setStyleName(i, "panelNotSelected");
		}
	}
	public void doLeftMenuforResources() {
		isLabsLinkSelected = false;
		LeftListPanel.labsTable.setVisible(false);
		LeftListPanel.resourcesTable.setVisible(true);
		labsPanel.setStyleName("panelNotSelected");
		resourcesPanel.setStyleName("panelSelected");
		for (int i = 0; i < LeftListPanel.resourcesTable.getRowCount(); i++) {
			LeftListPanel.resourcesTable.getRowFormatter().setStyleName(i, "panelNotSelected");
		}
	}
	public FilterPanel getFilterPanel() {
		return filterPanel;
	}
	public void setFilterPanel(FilterPanel filterPanel) {
		this.filterPanel = filterPanel;
	}
}
