package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EIClassCallback;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EIClassesCallback;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EISuperClassCallback;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;

public class ObjectWidget extends EditWidget {

	private ListBox rangePicker = new ListBox();
	private List<EIClass> rangeList = new ArrayList<EIClass>();
	private EIEntity selectedEntity;
	private EIClass instanceRootClass;
	private List<EIClass> instanceSuperclasses;
	private EditWidget innerWidget;
	private EIEntity labEntity;
	private boolean isEnabled = true;
	
	private Map<EIEntity,EIClass> entityRangeMap = new HashMap<EIEntity,EIClass>();
	
	private static final String NO_VALUE = "<none>";
	
	ObjectWidget(EIInstance eiInstance, EIEntity propertyEntity, List<EIClass>rangeList, EIEntity labEntity, EIEntity selectedEntity) {
		super(eiInstance, propertyEntity);
		Log.info("range list has " + rangeList.size() + " entries");
		this.rangeList = rangeList;
		this.selectedEntity = selectedEntity;
		Log.info("selected entity is: " + this.selectedEntity);
		this.labEntity = labEntity;
		
		getInstanceRootClass(); 
		
	}

	private void setup() {
		widgetPanel.add(rangePicker);
		rangePicker.addItem(NO_VALUE, NO_VALUE);
		
		for(EIClass range:rangeList) {
			entityRangeMap.put(range.getEntity(), range);
			rangePicker.addItem(range.getEntity().getLabel(), range.getEntity().getURI().toString());
			//FIXME instanceRootSuperClass may be way up in the hierarchy, and range may be more specific
			//but a child; this should return true in such cases.
			if(instanceRootClass == null && instanceSuperclasses != null && instanceSuperclasses.contains(range) ) {
				Log.info("selecting range: " + range);
				rangePicker.setSelectedIndex(rangePicker.getItemCount() - 1);
			} else if(instanceRootClass != null && range.getEntity().equals(instanceRootClass.getEntity()) ) {
				Log.info("selecting range with instanceRootClass: " + range);
				rangePicker.setSelectedIndex(rangePicker.getItemCount() - 1);
			} else if (hasLabUri() && WidgetUtils.isLabProperty(range)) {
				Log.info("selecting lab property " + range);
				rangePicker.setSelectedIndex(rangePicker.getItemCount() - 1);
			}
		}
		
		if(rangePicker.getSelectedIndex() > 0) {
			EIEntity selectedRange = getSelectedRangeEntity();
			if (entityRangeMap.get(selectedRange).isEagleIResource()) {
				if ((selectedEntity == null) && hasLabUri() && WidgetUtils.isLabProperty(selectedRange)) {
					Log.info("making lab-property for " + entityRangeMap.get(selectedRange) + " " + labEntity);
					eiInstance.addObjectProperty(propertyEntity, labEntity);
					innerWidget = new EIResourceWidget(eiInstance, propertyEntity, entityRangeMap.get(selectedRange), labEntity, false);
					disable();
				}
				else {
					Log.info("no lab");
					//TODO: (EIEntity): entity, not string!
					//innerWidget = new EIResourceWidget(eiInstance, propertyEntity, instanceRootClass, selectedEntity, false);
					innerWidget = new EIResourceWidget(eiInstance, propertyEntity, entityRangeMap.get(selectedRange), selectedEntity, false);
				}
				widgetPanel.add(innerWidget);
			}
			else {
				final HorizontalPanel tempPanel = new HorizontalPanel();
				widgetPanel.add(tempPanel);
				WidgetUtils.addTermWidgetToPanel(eiInstance, propertyEntity, instanceRootClass, selectedEntity, tempPanel, false);
			}
			
		} 
		
		rangePicker.addChangeHandler(new ChangeHandler() { 
			@Override
			public void onChange(ChangeEvent arg0) {
				if (rangePicker.getItemText(rangePicker.getSelectedIndex()).equals(NO_VALUE)) {
					if(widgetPanel.getWidgetCount() > 2) {
						widgetPanel.remove(2);
					}
					if (hasOldValue())
						removeValue();
				} else {
					if(widgetPanel.getWidgetCount() > 2) {
						if (getInnerWidget().hasOldValue())
							eiInstance.replaceObjectPropertyValue(propertyEntity, getInnerWidget().getOldEIURIValue(), null);
						widgetPanel.remove(2);
						innerWidget = null;
					}
					EIEntity selectedRange = getSelectedRangeEntity();
					Log.info("selected range now " + selectedRange);
					updateOldValue(selectedRange.getURI());
					if(entityRangeMap.get(selectedRange).isEagleIResource()) {
						innerWidget = new EIResourceWidget(eiInstance, propertyEntity, entityRangeMap.get(selectedRange), EIEntity.NULL_ENTITY, false);
						widgetPanel.add(innerWidget);
					} else {
						EIClass range = entityRangeMap.get(selectedRange);
						final HorizontalPanel tempPanel = new HorizontalPanel();
						widgetPanel.add(tempPanel);
						
						// TODO: inner callback to set the inner panel to the term widget created this way
						WidgetUtils.addTermWidgetToPanel(eiInstance, propertyEntity, range, selectedEntity, tempPanel, false);
					}
				}
			}
		});
	}

	private void getInstanceRootClass() {
		if (selectedEntity == null){
			setup();
			return;
		}
		
		// TODO: entity, not uri!
		if (WidgetUtils.isInstanceUri(selectedEntity.getURI().toString())) {
			
			Log.info("Trying to get superclasses for instance: " + selectedEntity);
			//ClientRepositoryToolsManager.INSTANCE.getRootSuperclassForInstanceUri(selectedEntity.getURI(), new EIClassCallback(){
			ClientRepositoryToolsManager.INSTANCE.getClassAndSuperclassesForInstanceUri(selectedEntity.getURI(), new EIClassesCallback(){

				@Override
				public void onSuccess(List<EIClass> result) {
					//instanceRootClass = result;
					instanceSuperclasses = result;
					Log.info("Got superclasses: " + instanceSuperclasses);
					setup();
				}
				
				//@Override
				//public void onFailure(String result) {
				//	Log.error("Server call getRootSuperclassForInstanceUri failed : "+result);
				//	setup();
				//}
				
			});
		}
		else {
			Log.info("in getInstanceRootClass for " + selectedEntity);
			ClientOntologyToolsManager.INSTANCE.getEIClass(selectedEntity.getURI(), new EIClassCallback() {
				
				@Override
				public void onSuccess(EIClass result) {
					ClientOntologyToolsManager.INSTANCE.getRootSuperClass(result, new EISuperClassCallback() {					
						@Override
						public void onSuccess(EIClass superclass) {
							instanceRootClass = superclass;
							setup();
						}
					});
				}
				
				@Override
				public void onFailure(String result) {
					Log.error("Server getEIClass call failed : "+result);
					setup();
				}
			});
		}
	}

	private EIEntity getSelectedRangeEntity() {
		return WidgetUtils.getSelectedEntity(rangePicker);
	}
	
	@Deprecated
	private EIURI getSelectedRangeUri() {
		return WidgetUtils.getSelectedUri(rangePicker);
	}
	
	protected EditWidget getInnerWidget() {
		if (innerWidget != null)
			return innerWidget;
		else if (widgetPanel.getWidgetCount() > 2){ 
			Widget widget = widgetPanel.getWidget(2);
			if (widget instanceof HorizontalPanel) {
				widget = ((HorizontalPanel)widget).getWidget(0); // ?
			}
			
			if (widget instanceof EditWidget) {
				EditWidget inner = ((EditWidget) widget);
				return inner;
			} else {
				Window.alert("you failed to get an editWidget, dummy!"); // TODO: remove
			}
		}
		
		return null;
	}
	
	@Override
	protected void removeValue() {
		getInnerWidget().removeValue();
	}

	@Override
	public EditWidget duplicateBlank() {
		return new ObjectWidget(eiInstance, propertyEntity, rangeList, labEntity, null);
	}
	
	// TODO: make static in WidgetUtils
	protected boolean hasLabUri() {
		return (labEntity != null) && (! labEntity.getURI().toString().equals(""));
	}
	
	public void disable() {
		rangePicker.setEnabled(false);
		if (innerWidget instanceof EIResourceWidget) {
			((EIResourceWidget) innerWidget).disable();
		}
		isEnabled = false;
	}
	
	public boolean isDisabled() {
		return ! isEnabled;
	}
}
