package org.eaglei.datatools.client.ui;

import java.util.List;

import org.eaglei.model.EIClass;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EIClassesCallback;
import org.eaglei.suggest.client.OntologyDropdownBase;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;

public class OntologyDropdown extends OntologyDropdownBase {
 
    public OntologyDropdown() {
    	super.init();
    }
    
    public void setResource(EIClass resource) { 
    	if(resource!=null) {
	        rootClass = resource;
	        this.setTitle("Taxonomy Browser for Class " + rootClass.getEntity().getLabel());
	        if (tree != null) {
	            tree.clear();
	            scroll.getElement().getStyle().clearHeight();
	        }
	        if (rootClass.hasSubClass()) {
	            if (tree != null) {
	                 tree.add(ApplicationImages.LOADING);
	            }
	            rootListLoading = true;
	        } else {
	            // Probably should assert...
	            if (tree != null) {
	                tree.addItem("No types are available");
	            }
	        }
    	} else { 
    		this.setTitle(WorkFlowConstants.NO_ONTOLOGY_TERMS);
    		button.setVisible(false);
    		this.setStyleName("OntologyDropDownNoTerm");
    	} 
    }

    /**
     * Popup display click event.
     */
    protected void doOnClick(ClickEvent event) { 
        if (rootClass != null && rootListLoading) {
            DeferredCommand.addCommand(new Command() {

                public void execute() {
                    if (! rootListLoading) {
                        return;
                    }
                    
                    ClientOntologyToolsManager.INSTANCE.getSubClasses(rootClass.getEntity().getURI(), true, new EIClassesCallback() {

						@Override
						public void onSuccess(List<EIClass> result) {
                            tree.clear();
                            addNullItem();
                            for (EIClass resource : result) {
                                TreeItem item;
                                ResourceTreeWidget w = new ResourceTreeWidget(resource);
                                item = tree.addItem(w);
                                if (resource.hasSubClass()) {
                                    item.addItem(ApplicationImages.LOADING);
                                    w.childListLoading = true;
                                }
                            }
                            rootListLoading = false;
                            setPopupHeight();
							
						}

						private void addNullItem() {
							tree.addItem(new ResourceTreeWidget(EIClass.NULL_CLASS));
						}
                        
                    });
                }

            });
        } 
        if (popup != null) {
            popup.setVisible(false);
            popup.show();
            setPopupHeight();
        }
    }

    @Override
    protected void populateChildList(final TreeItem item) { 
        final ResourceTreeWidget w = (ResourceTreeWidget) item.getWidget();
        EIClass resource = w.getResource(); 
        if (resource.getSubClasses() != null) {
            populateChildList(item, w, resource.getSubClasses());
        } else {
        	ClientOntologyToolsManager.INSTANCE.getSubClasses(resource.getEntity().getURI(), true, new EIClassesCallback() {

                public void onSuccess(EIClass result) {
                    // Check that the child list hasn't already been
                    // populated by another thread.
                    if (! w.childListLoading) {
                        return;
                    }
                    populateChildList(item, w, result.getSubClasses());
                }

				@Override
				public void onSuccess(List<EIClass> result) {
					  // Check that the child list hasn't already been 
                    // populated by another thread.
                    if (! w.childListLoading) {
                        return;
                    }
                    populateChildList(item, w, result);
				}
            });
        }
    }
    
    @Override
    protected void populateChildList(final TreeItem parent, ResourceTreeWidget parentWidget, List<EIClass> subclasses) {
        parent.removeItems();
        for (EIClass r : subclasses) {
            TreeItem child;
            ResourceTreeWidget childWidget = new ResourceTreeWidget(r);
            child = parent.addItem(childWidget);
            if (r.hasSubClass()) {
                child.addItem(ApplicationImages.LOADING);
                childWidget.childListLoading = true;
            }
        }
        parentWidget.childListLoading = false;
        setPopupHeight();
    }
    
    private void setPopupHeight() {
        DeferredCommand.addCommand(new Command() {
            public void execute() {
                int h = tree.getOffsetHeight();
                int maxHeight = computeMaxHeight();
                if (h > maxHeight) {
                    scroll.setHeight(maxHeight + "px");
                } else {
                    scroll.getElement().getStyle().clearHeight();
                }
                popup.showRelativeTo(p);
                if(rootClass==null)
                	popup.hide();
            }
        });
        
    }
    
    private int computeMaxHeight() {
        // Calculate top position for the popup
        int top = p.getAbsoluteTop();

        // Make sure scrolling is taken into account, since
        // widget.getAbsoluteTop() takes scrolling into account.
        int windowTop = Window.getScrollTop();
        int windowBottom = Window.getScrollTop() + Window.getClientHeight();

        // Distance from the top edge of the window to the top edge of the
        // widget
        int distanceFromWindowTop = top - windowTop;

        // Distance from the bottom edge of the window to the bottom edge of
        // the widget
        int distanceToWindowBottom = windowBottom
            - (top + p.getOffsetHeight());

        // Prefer displaying below
        if (distanceToWindowBottom > 200) {
            return distanceToWindowBottom - 10;
        } else if (distanceFromWindowTop > 200) {
            return distanceFromWindowTop - 10;
        } else {
            return distanceToWindowBottom > distanceFromWindowTop ? distanceToWindowBottom - 10 : distanceFromWindowTop - 10;
        }
    }
}
