package org.eaglei.datatools.client.ui;



import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.ResultsCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.WFCallback;
import org.eaglei.model.EIURI;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

/**
 * The top panel, header logo, sign in, etc
 */
public class TopPanel extends Composite implements ClientRepositoryToolsManager.SessionListener  {

    interface Binder extends UiBinder<Widget, TopPanel> {
    }

    private static final Binder binder = GWT.create(Binder.class);
    @UiField
    Label welcomeLabel;
    @UiField
    Anchor logoutAnchor;
    @UiField
    Anchor changePassword;
    @UiField
    UListElement loginList;
    @UiField
    TextBox userTextBox;
    @UiField
    PasswordTextBox passTextBox;
    @UiField
    Button loginButton;
    @UiField
    Image logo;
    
    boolean signedIn = false;

    public static String[] wfStates;
    
    public static Map<String,Boolean> accessMap = new HashMap<String,Boolean>(); 
    
    public TopPanel() {
        initWidget(binder.createAndBindUi(this));
        passTextBox.addKeyUpHandler(new KeyUpHandler() {
            @Override
            public void onKeyUp(KeyUpEvent event) {
                if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
                    performLogin();
                }
            }
        });
        
        if (!signedIn) {
        	logoutAnchor.setVisible(false);
        	changePassword.setVisible(false);
        }
        
        String url = GWT.getHostPageBaseURL();
        int startIndex = -1;
        
        int endIndex = url.indexOf(".eagle-i.net");
        if(url.indexOf(".")>0 && url.indexOf(".") < endIndex){
       		startIndex = url.indexOf(".")+1;
        } else {
        	startIndex = url.indexOf("//")+2;
        }
        
        String imageName =  url.substring(startIndex, endIndex); 
        logo.setUrl("images/"+imageName+"_logo.png");
        loginButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                performLogin();
            }
        });
        
        logoutAnchor.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                if (signedIn) {
                   performLogout();
                }
            }
        });
        
        changePassword.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
            	String url = GWT.getHostPageBaseURL().substring(7); //ignore 'http://'
            	String repoUrl = url.substring(0,url.indexOf("/")+1); 
            	if (signedIn) {
                   Window.open("http://"+repoUrl+"repository/editUser.html", "Change Password", "");
                }
            }
        });
        
        if (DatatoolsCookies.hasSession())
		{
			signedIn = true;
			Log.info("top panel already logged in");
		}
		
        ClientRepositoryToolsManager.INSTANCE.addSessionListener(this);
    }

    private void performLogin() {
    	
    	String user = userTextBox.getText();
        if (user == null || user.trim().length() == 0) {
            Window.alert(WorkFlowConstants.NO_USER);
            return;
        } 
        String pass = passTextBox.getText();
        if (pass == null || pass.trim().length() == 0) {
            Window.alert(WorkFlowConstants.NO_PASSWORD);
            return;
        }
        ClientRepositoryToolsManager.INSTANCE.logIn(user.trim(), pass.trim(),  new ResultsCallback() {
			@Override
			public void loginRequired() {
				// TODO Auto-generated method stub
			}

			@Override
			public void onSuccess(String[] result) {
			}

			@Override
			public void onSuccess(String arg0) {
				// TODO Auto-generated method stub
				
			}
        });
    }
    
    private void performLogout() {
    	ClientRepositoryToolsManager.INSTANCE.logOut();
	}


    @Override
    public void onLogOut() {
    	welcomeLabel.setText("Please login");  
        loginList.getStyle().setVisibility(Style.Visibility.VISIBLE);
        changePassword.setVisible(false);
        signedIn = false;
        userTextBox.setText("");
        passTextBox.setText("");
        logoutAnchor.setVisible(false);
    }

	@Override
	public void onLogIn(String username, String userUri) {
			welcomeLabel.setText("Welcome, "+username);
	        changePassword.setVisible(true);
	        logoutAnchor.setVisible(true);
	        //userURI.setText(text);
	        loginList.getStyle().setVisibility(Style.Visibility.HIDDEN);
	        signedIn = true;
	        Anchor backLink = new Anchor("Back");
			backLink.addClickHandler(new ClickHandler() {
				@Override
				public void onClick(ClickEvent arg0) {
					History.back();
				}
			});
			RootPanel.get("back_container").add(backLink);
	}
}
