package org.eaglei.datatools.client.ui;

import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;

public class ValidatedTextWidget extends TextWidget {
	
	public ValidatedTextWidget(EIInstance eiInstance, EIEntity propertyEntity, String propertyValue, OldValueHandler handler) {
		super(eiInstance, propertyEntity, propertyValue, handler);
	}
	
	@Override
	protected ValueChangeHandler<String> getValueChangeHandler() {
		return new ValueChangeHandler<String>() {
			@Override
			public void onValueChange(ValueChangeEvent<String> changedValue) {
				if (!validate()) {
					oldValueHandler.replaceValue(eiInstance, propertyEntity, oldValue, "");
				} else if(hasOldValue()) {
					oldValueHandler.replaceValue(eiInstance, propertyEntity, oldValue, changedValue.getValue());
				} else {
					oldValueHandler.addValue(eiInstance, propertyEntity, changedValue.getValue());
				}
				updateOldValue(changedValue.getValue());
			}
		};
	}
	
	@Override public EditWidget duplicateBlank() {
		return new ValidatedTextWidget(eiInstance, propertyEntity, "", oldValueHandler);
	}
	
	private boolean validate() {
		// TODO: any better way of doing this so someone can tab away & come back?
		// Maybe validate the *instance values* when we save?
		if (!Validations.IsEmailBox(getValueText()) && !getValueText().equals("")) {
			errLabel.setText("Only emails are allowed");
			setFieldValue("");
			return false;
		} else {
			errLabel.setText("");
			return true;
		}
	}
}

