package org.eaglei.datatools.client.ui;

import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientOntologyToolsManager.EIClassCallback;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.EIInstanceCallback;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * Collection of static utility methods required for form generation
 */
public class WidgetUtils {

	public interface InstanceSaveCallback {
		public void updateState(EIInstance newInstance);
	}
	/**
	 * 
	 * @param propertyEntity
	 * @return
	 */
	public static Label createLabel(EIEntity propertyEntity) {
		if (propertyEntity == null)
			return createLabel("");
		return createLabel(propertyEntity.getLabel());
	}
	
	public static Label createLabel(String label) {
		Label propLabel = new Label(label);
		propLabel.setStyleName("formLabel");
		return propLabel;
	}
	
	/**
	 * Some field values that are retrieved from the repo have extra bit of data attached. 
	 * This method eliminates the unwanted data in the value.
	 * 
	 * @return formatted value String
	 */
	public static String formatText(String value) {
		if (value.indexOf("^") > 0) {
			return value.substring(0, value.indexOf("^"));
		}
		return value;
	}
	
	public static TextBox createTextField() {
		TextBox textField = new TextBox();
		textField.setStyleName("formText");
		return textField;
	}
	
	public static TextBox createTextFieldForResourceWidget() {
		TextBox textField = new TextBox();
		textField.setStyleName("textSuggest");
		return textField;
	}
	
	public static void addTermWidgetToPanel(final EIInstance eiInstance, final EIEntity propertyEntity, final EIClass range, final String selectedClassUri, final EditWidgetCollection fields, final boolean showLabel) {
		// TODO: get rid of this when we get back EIEntity in maps rather than EIURIs
		ClientOntologyToolsManager.INSTANCE.getEIClass(EIURI.create(selectedClassUri), new EIClassCallback() {

			@Override
			public void onFailure(String result) {
				Log.error("failed to get root superclass for " + selectedClassUri);
				fields.addWidget(new TermWidget(eiInstance, propertyEntity, range, null, showLabel));
			}

			@Override
			public void onSuccess(EIClass result) {
				Log.info("got root superclass for " + selectedClassUri+ " Superclass is "+ result);
				fields.addWidget(new TermWidget(eiInstance, propertyEntity, range, result,showLabel));
			}		
		});
		
	}
	
	public static void addTermWidgetToPanel(final EIInstance eiInstance, final EIEntity propertyEntity, final EIClass range, final EIEntity selectedClassEntity, final HorizontalPanel tempPanel, final boolean showLabel) {
		if (selectedClassEntity == null || selectedClassEntity == EIEntity.NULL_ENTITY ) {
			tempPanel.add(new TermWidget(eiInstance, propertyEntity, range, EIClass.NULL_CLASS, showLabel));
		}
		
		ClientOntologyToolsManager.INSTANCE.getEIClass(selectedClassEntity.getURI(), new EIClassCallback() {

			@Override
			public void onFailure(String result) {
				Log.error("failed to get class for " + selectedClassEntity);
				tempPanel.add(new TermWidget(eiInstance, propertyEntity, range, null, showLabel));
			}

			@Override
			public void onSuccess(EIClass result) {
				Log.info("got class for " + selectedClassEntity + " class is "+ result);
				tempPanel.add(new TermWidget(eiInstance, propertyEntity, range, result, showLabel));
			}		
		});
	}
	
	public static HorizontalPanel createRadioButon(final EIInstance instance, final EIEntity propertyEntity, String value) {
		HorizontalPanel hPanel = new HorizontalPanel();
		CheckBox checkBox = new CheckBox();
		if (value != null) {
			checkBox.setValue(Boolean.valueOf(value));
		}
		hPanel.add(createLabel(propertyEntity));
		hPanel.add(checkBox);
		checkBox.addValueChangeHandler(new ValueChangeHandler<Boolean>() {
			@Override
			public void onValueChange(ValueChangeEvent<Boolean> arg0) {
				Boolean oldValue = !(arg0.getValue());
				instance.replaceDatatypePropertyValue(propertyEntity, oldValue.toString(), arg0.getValue().toString());
			}
		});
		return hPanel;
	}

	public static boolean isInstanceUri(String selectedUri) {
		if (selectedUri == null || selectedUri.equals(""))
			return false;
		
		return selectedUri.indexOf("/i/") != -1;  //TODO: TOTAL HACK
	}
	
	public static String getWFStateString(final EIInstance instance) {
		return instance.getWFState() == null ? "" : instance.getWFState().getURI().toString();
	}
	
	public static EIEntity getSelectedEntity(ListBox listBox) {
		final int selectedIndex = listBox.getSelectedIndex();
		return EIEntity.create(getSelectedUri(listBox), listBox.getItemText(selectedIndex));
	}

	@Deprecated
	public static EIURI getSelectedUri(ListBox listBox) {
		EIURI selectedUri = EIURI.create(listBox.getValue(listBox.getSelectedIndex()));
		return selectedUri;
	}
	
	public static boolean isLabProperty(EIEntity range) {
		if (range == null)
			return false;
		return (range.getURI().toString().equals(DatatoolsUIConstants.EI_LAB) || range.getURI().toString().equals(DatatoolsUIConstants.EI_CORE_LAB));
	}
	
	public static boolean isLabProperty(EIClass range) {
		if (range == null || range.getEntity() == null)
			return false;
		return isLabProperty(range.getEntity());
	}
	
	public static PopupPanel createDialog(final EIInstance parentInstance, final EIClass range, final EIEntity propertyEntity, final EIURI oldValue, final int position, final InstanceSaveCallback innerCallback) {
		final PopupPanel window = new PopupPanel();
		final VerticalPanel vPanel = new VerticalPanel();
		int left = (Window.getClientWidth()) / 2;
		int top = position;
		window.setWidget(vPanel);
		window.setStyleName("dialogWindow");
		window.setPopupPosition(left, top);
		window.setModal(true);
		
		final EditFormRedisplay redisplay = new EditFormRedisplay() {
			@Override
			public void drawAfterPromote(EIInstance instance) {
			}
			
			@Override
			public void drawAfterDuplicate(EIInstance instance) {
			}
			
			@Override
			public void drawAfterSave(EIInstance instance) {
				innerCallback.updateState(instance);
				window.hide();	
			}
			
			@Override
			public void drawAfterCancel(EIInstance instance) {
				window.hide();
			}
		};
		final VerticalPanel newPanel = new FormsPanel().generateNewForm(range.getEntity().getURI(), true, redisplay);
		vPanel.add(newPanel);
		
		return window;
	}
}
