package org.eaglei.datatools.client.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.ResultsCallback;
import org.eaglei.model.EIInstance;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.Window;

public class WorkFlowAction {

	public static WorkFlowAction CurationAction = new WorkFlowAction(WorkFlowConstants.CURATION_ACTION, WorkFlowConstants.DRAFT_STATE, WorkFlowConstants.CURATION_STATE);
	public static WorkFlowAction PublishAction = new WorkFlowAction(WorkFlowConstants.PUBLISH_ACTION, WorkFlowConstants.CURATION_STATE, WorkFlowConstants.PUBLISH_STATE);
	public static WorkFlowAction WithdrawAction = new WorkFlowAction(WorkFlowConstants.WITHDRAW_ACTION, WorkFlowConstants.PUBLISH_STATE, WorkFlowConstants.WITHDRAW_STATE);
	public static WorkFlowAction ReturnToDraftAction = new WorkFlowAction(WorkFlowConstants.DRAFT_ACTION, WorkFlowConstants.CURATION_STATE, WorkFlowConstants.DRAFT_STATE);
	
	private static Map<WorkFlowAction, List<String>> allowedActions;
	
	private final String name;
	private final String fromState;
	private final String toState;
	
	private WorkFlowAction(String name, String from, String to)
	{
		this.name = name;
		fromState = from;
		toState = to;
		
		if (allowedActions == null) {
			allowedActions = new HashMap<WorkFlowAction, List<String>>();
		}
		if (allowedActions.get(this) == null) {
			allowedActions.put(this, new ArrayList<String>(2));
		}
		allowedActions.get(this).add(from);
	}

	public String getName() {
		return name;
	}

	public String getFromState() {
		return fromState;
	}

	public String getToState() {
		return toState;
	}
	
	public void perform(final EIInstance instance, final FormRedisplay redisplay) { 
		try {
			ClientRepositoryToolsManager.INSTANCE.promote(instance, this.getToState(), new ResultsCallback() {
				@Override
				public void onSuccess(String[] arg0) {
					redisplay.drawAfterPromote(instance);
				}

				@Override
				public void onSuccess(String arg0) {
					redisplay.drawAfterPromote(instance);
				}

				@Override
				public void loginRequired() {
					
				}
				
			});
		} catch (Exception e) {
			e.printStackTrace();
			Window.alert(e.getMessage());
		}
	}
	
	public static String getAlertMessage(WorkFlowAction action)
	{
		String base = WorkFlowConstants.BULK_OPERATION_ERROR;
		
		String statusList = "";
		for (String status : allowedActions.get(action))
		{
			statusList += ", " + status;
		}
		statusList = statusList.replaceFirst(", ", "");
		Log.info("status list " + statusList);
		
		base = base.replace("$STATE$", statusList);
		base = base.replace("$ACTION$", action.getName());
		
		return base;
	}
}
