package org.eaglei.datatools.client;

import java.util.List;

import org.eaglei.datatools.User;
import org.eaglei.datatools.Workspace;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.UserCallback;
import org.eaglei.datatools.client.ui.ApplicationState;
import org.eaglei.datatools.client.ui.EagleiGlassPane;
import org.eaglei.datatools.client.ui.LeftListPanel;
import org.eaglei.datatools.client.ui.MainController;
import org.eaglei.datatools.client.ui.TopPanel;
import org.eaglei.datatools.client.ui.WorkflowUtils;
import org.eaglei.datatools.client.ui.widgets.WorkspaceChooserPopup;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.FooterPanel;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * This is the Entry point class, mainly responsible for creating the Top level
 * Tabs
 * 
 * @author pp101
 * 
 */
public class Datatools implements ClientRepositoryToolsManager.SessionListener {

	private String							currentUser;
	private static User						userObject;
	private HorizontalPanel					mainPanel;
	public static boolean					isRefresh;
	private TopPanel						topPanel	= null;
	private boolean							initialized	= false;
	private LeftListPanel					leftList;
	private MainController					mainController;
	private static final VerticalPanel		dataPanel	= new VerticalPanel();
	protected static final EagleiGlassPane	glasspane	= new EagleiGlassPane();

	/**
	 * Entry point method
	 */
	public void onModuleLoad() {
	/*	GWT.setUncaughtExceptionHandler(new GWT.UncaughtExceptionHandler() {

			@Override
			public void onUncaughtException(Throwable e) {
				StringBuffer sbuf = new StringBuffer();
				for (StackTraceElement ele : e.getStackTrace()) {
					sbuf.append(ele.getFileName() + " " + ele.getClassName() + " " + ele.getMethodName() + " " + ele.getLineNumber());
					sbuf.append('\n');
				}
				Log.error(sbuf.toString());
			//		Window.alert("there is uncought Exception "+'\n'+'\n'+sbuf.toString());
			}
		});*/
		initialized = false;
		Log.info("making new main controller");
		mainController = new MainController();
		RootPanel footerSlot = RootPanel.get("footer_container");
		String version = footerSlot.getElement().getInnerText();
		footerSlot.getElement().setInnerText("");
		final FooterPanel footerPanel = new FooterPanel(version);
		footerSlot.add(footerPanel);
		currentUser = DatatoolsCookies.getUserName();
		// If there are cookies, check that they're real by talking to the client manager.  If not, reset user & user URI to null.
		// Since userUri is necessarily a mutable local variable, do this by checking currentUser and *then* nulling userUri afterward.
		if (currentUser != null) {
			//Window.alert("Datatools current user: " + currentUser);
			//Window.alert("do we have a manager? " + (ClientRepositoryToolsManager.INSTANCE == null ? "no" : "yes"));
			try {
				ClientRepositoryToolsManager.INSTANCE.whoami(new UserCallback() {

					@Override
					public void onSuccess(User userInfo) {
						if (userInfo == null) {
							Log.debug("failed to get any user info from whoami");
							handleNotLoggedIn();
							initialize();
							return;
						}
						Datatools.setUser(userInfo);
						String user = userInfo.getUserName();
						if (user == null) {
							Log.debug("did whoami; user null, removing cookies");
							handleNotLoggedIn();
							initialize();
							return;
						}
						if (!user.equals(currentUser)) {
							Log.debug("did whoami; user not same as current user, removing cookies");
							handleNotLoggedIn();
							initialize();
							return;
						}
						Log.debug("did whoami: confirms signed in as " + user + "; had " + (userInfo.getWFSStateList().size()) + " workflow states");
						initialize();
						return;
					}

					@Override
					public void loginRequired() {
						Log.debug("did whoami; login required, removing cookies");
						handleNotLoggedIn();
						initialize();
						return;
					}
				});
			} catch (Exception e) {
				Log.warn("did whoami; exception thrown--setting user to null & removing cookies");
				Log.warn(e.getMessage());
				handleNotLoggedIn();
				initialize();
			}
		} else {
			//Window.alert("Datatools: no user; is initialized? " + initialized);
			if (!initialized) {
				initialize();
				return;
			}
		}
	}

	private void initialize() {
		initialized = true;
		if (!Window.Location.getHash().equals("")) {
			isRefresh = true;
			Log.info("token from window: " + Window.Location.getHash());
			ApplicationState.newInstance(Window.Location.getHash());
		}
		String userUri = DatatoolsCookies.getUserUri();
		if (currentUser == null) {
			userUri = null;
		}
		if (userUri != null) {
			ApplicationState.getInstance().setUser(EIEntity.create(EIURI.create(userUri), currentUser));
			Log.info("User uri " + ApplicationState.getInstance().getUserURI() + "; label " + ApplicationState.getInstance().getUserID());
		}
		if (topPanel == null) {
			topPanel = new TopPanel();
			RootPanel.get("header_container").add(topPanel);
		}
		mainPanel = new HorizontalPanel();
		dataPanel.setStyleName("dataPanel");
		leftList = new LeftListPanel();
		mainPanel.add(leftList);
		mainPanel.add(dataPanel);
		RootPanel.get("main_container").add(mainPanel);
		if (userUri != null) {
			topPanel.onLogIn(currentUser, userUri);
		}
		ClientRepositoryToolsManager.INSTANCE.addSessionListener(this);
		leftList.onApplicationStateChange();
		mainController.onApplicationStateChange();
		ApplicationState.getInstance().addApplicationStateListener(topPanel);
	}

	private void handleNotLoggedIn() {
		ApplicationState.getInstance().setUser(EIEntity.NULL_ENTITY);
		DatatoolsCookies.removeCookies();
		//isRefresh = false;
		ClientRepositoryToolsManager.INSTANCE.logOut();
	}

	@Override
	public void onLogIn(String username, String userUri) {
		ApplicationState.getInstance().setUser(EIEntity.create(userUri, username));
		topPanel.onLogIn(username, userUri);
		mainController.onLogIn(username, userUri);
	}

	@Override
	public void onLogOut() {
		Log.info("datatools logging out; redirecting to " + GWT.getModuleBaseURL());
		ApplicationState.getInstance().setUser(EIEntity.NULL_ENTITY);
		mainController.onLogOut();
		leftList.onLogOut();
		if (!isRefresh) {
			Window.Location.assign("");
			ApplicationState.getInstance().clearApplicationState();
		}
	}

	public static void showGlasspane() {
		glasspane.add(new Image("images/ajax-loader.gif"));
		glasspane.show();
	}

	public static void hideGlasspane() {
		glasspane.hide();
	}

	public static void clearDataPanel() {
		dataPanel.clear();
	}

	public static void handleLoginRequired() {
		clearDataPanel();
		HTML errorMessage = new HTML("<font color='red'><b> Please sign in.</b></font>");
		dataPanel.add(errorMessage);
	}

	public static void showData(Widget widget) {
		clearDataPanel();
		hideGlasspane();
		dataPanel.add(widget);
	}

	public static User getUser() {
		return userObject;
	}

	public static void setUser(User user) {
		Datatools.userObject = user;
	}

	public static void   showWorkspaceChooser(final List<Workspace> result) {
		final WorkspaceChooserPopup chooser = new WorkspaceChooserPopup(result);
		chooser.addConfirmClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				Workspace selectedWorkspace = chooser.getSelectedWorkspace();
				ApplicationState.getInstance().setWorkspaceEntity(EIEntity.create(selectedWorkspace.getWorkspaceURI(), selectedWorkspace.getWorkspaceName()));
				chooser.hide();
			}
		});
		chooser.show();
	}
}
