package org.eaglei.datatools.client.ui;

import java.util.HashMap;
import java.util.Map;

import org.eaglei.datatools.client.Datatools;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager.ResultsCallback;
import org.eaglei.datatools.client.ui.QueryTokenObject.Mode;
import org.eaglei.model.EIEntity;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

/**
 * The top panel, header logo, sign in, etc
 */
public class TopPanel extends Composite implements ClientRepositoryToolsManager.SessionListener, ApplicationStateChangeListener {

	interface Binder extends UiBinder<Widget, TopPanel> {
	}

	private static final Binder			binder		= GWT.create(Binder.class);
	@UiField
	Label								welcomeLabel;
	@UiField
	Anchor								logoutAnchor;
	@UiField
	Label								logoutSeparator;
	@UiField
	Anchor								changePassword;
	@UiField
	Label								changePasswordSeparator;
	@UiField
	UListElement						loginList;
	@UiField
	TextBox								userTextBox;
	@UiField
	PasswordTextBox						passTextBox;
	@UiField
	Button								loginButton;
	@UiField
	Image								logo;
	@UiField
	Anchor								searchLink;
	@UiField
	Anchor								glossaryLink;
	@UiField
	Anchor								helpLink;
	boolean								signedIn	= false;
	public static String[]				wfStates;
	public static Map<String, Boolean>	accessMap	= new HashMap<String, Boolean>();

	public TopPanel() {
		initWidget(binder.createAndBindUi(this));
		passTextBox.addKeyUpHandler(new KeyUpHandler() {

			@Override
			public void onKeyUp(KeyUpEvent event) {
				if (event.getNativeKeyCode() == KeyCodes.KEY_ENTER) {
					performLogin();
				}
			}
		});
		if (!signedIn) {
			logoutAnchor.setVisible(false);
			logoutSeparator.setVisible(false);
			changePassword.setVisible(false);
			changePasswordSeparator.setVisible(false);
		}
		searchLink.setHref(getSearchURL() == null ? "http://search.eagle-i.net/central/" : getSearchURL());
		searchLink.setTarget("_blank");
		glossaryLink.setHref(WidgetUtils.getGlossaryURL() == null ? "http://search.eagle-i.net/model/" : WidgetUtils.getGlossaryURL());
		glossaryLink.setTarget("_blank");
		helpLink.addClickHandler(new ClickHandler() {

			public void onClick(final ClickEvent clickEvent) {
				Window.open(WidgetUtils.getHelpURL(), "_blank", "height=" + (getHelpWindowHeight()) + ",width=" + getHelpWindowWidth() + ",left=" + (getHelpWindowLeft()) + ",top=0");
			}
		});
		String imageName = WidgetUtils.getNodeNameFromURL();
		logo.setUrl("images/" + imageName + "_logo.png");
		loginButton.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				performLogin();
			}
		});
		logoutAnchor.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {
				if (signedIn) {
					performLogout();
				}
			}
		});
		changePassword.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent event) {

				if (signedIn) {
					Window.open(WidgetUtils.getChangePasswordURL(), "_blank", "height=" + (getHelpWindowHeight()) + ",width=" + getHelpWindowWidth() + ",left=" + (getHelpWindowLeft()) + ",top=0");
				}
			}
		});
		if (DatatoolsCookies.hasSession()) {
			signedIn = true;
			Log.info("top panel already logged in");
		}
		ClientRepositoryToolsManager.INSTANCE.addSessionListener(this);
	}

	private void performLogin() {
		String user = userTextBox.getText();
		if (user == null || user.trim().length() == 0) {
			Window.alert(UIMessages.NO_USER);
			return;
		}
		String pass = passTextBox.getText();
		if (pass == null || pass.trim().length() == 0) {
			Window.alert(UIMessages.NO_PASSWORD);
			return;
		}
		ClientRepositoryToolsManager.INSTANCE.logIn(user.trim(), pass.trim(), new ResultsCallback() {

			@Override
			public void loginRequired() {
				// TODO Auto-generated method stub
			}

			@Override
			public void onSuccess(String[] result) {
			}

			@Override
			public void onSuccess(String arg0) {
				// TODO Auto-generated method stub
			}
		});
	}

	private void performLogout() {
		ClientRepositoryToolsManager.INSTANCE.logOut();
	}

	@Override
	public void onLogOut() {
		welcomeLabel.setText("Please login");
		loginList.getStyle().setVisibility(Style.Visibility.VISIBLE);
		changePassword.setVisible(false);
		signedIn = false;
		userTextBox.setText("");
		passTextBox.setText("");
		logoutAnchor.setVisible(false);
		logoutSeparator.setVisible(false);
	}

	@Override
	public void onLogIn(String username, String userUri) {
		RootPanel.get("back_container").clear();
		welcomeLabel.setText("Welcome, " + username);
		changePassword.setVisible(true);
		changePasswordSeparator.setVisible(true);
		logoutAnchor.setVisible(true);
		logoutSeparator.setVisible(true);
		//userURI.setText(text);
		loginList.getStyle().setVisibility(Style.Visibility.HIDDEN);
		signedIn = true;
		FlowPanel flowPanel = new FlowPanel();
		
		Anchor backLink = new Anchor("Back");
		flowPanel.add(backLink);
		backLink.addClickHandler(new ClickHandler() {

			@Override
			public void onClick(ClickEvent arg0) {
				back(arg0);
				//Datatools.showWorkspaceChooser(Datatools.getUser().getWorkspaces());
			}
		});
		RootPanel.get("back_container").add(flowPanel);
		
		
	}

	private String getSearchURL() {
		String url = GWT.getHostPageBaseURL();
		String node = WidgetUtils.getNodeNameFromURL();
		if (node != null) {
			String searchUrl = url.replace(node + ".", "search.").replace("/datatools/", "") + "/central/";
			return searchUrl;
		} else {
			return null;
		}
	}

	

	private void back(ClickEvent arg0) {
		Anchor link = (Anchor) arg0.getSource();
		// Do *NOT* wipe out app state here if history.getToken() is ""; that ruins bookmarks if you've logged out.
		if (!History.getToken().equals("")) {
			link.setVisible(true);
			History.back();
		}
	}

	@Override
	public void onApplicationStateChange() {
		if (RootPanel.get("back_container").getWidget(0) != null)
			RootPanel.get("back_container").getWidget(0).setVisible(!History.getToken().equals(""));
	}

	private int getHelpWindowHeight() {
		return Window.getClientHeight() + Window.getClientHeight() / 12;
	}

	private int getHelpWindowWidth() {
		return 600;
	}

	private int getHelpWindowLeft() {
		return Window.getClientWidth() - getHelpWindowWidth();
	}
}
