package org.eaglei.datatools.client.ui;

import java.util.List;

import org.eaglei.datatools.User;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIURI;

/**
 * Collection of static utility methods required for workflow
 */


import com.allen_sauer.gwt.log.client.Log;

public class WorkflowUtils {

	public static boolean instanceHasAnyOwner(final EIInstance instance) {
		return isNotNull(instance.getWFOwner());
	}
	
	public static boolean instanceHasCurrentOwner(final EIInstance instance, final User currentUser) {
		return isNotNull(instance.getWFOwner()) && instance.getWFOwner().equals(EIEntity.create(currentUser.getUserURI(), currentUser.getUserName()));
	}

	public static boolean instanceHasAnyOwner(final EIInstanceMinimal instance) {
		return isNotNull(instance.getWFOwner());
	}

	public static boolean instanceHasCurrentOwner(final EIInstanceMinimal instance, final User currentUser) {
		return isNotNull(instance.getWFOwner()) && instance.getWFOwner().equals(EIEntity.create(currentUser.getUserURI(), currentUser.getUserName()));
	}

	public static boolean instanceHasWorkflowState(final EIInstance instance) {
		return isNotNull(instance.getWFState());
	}

	public static boolean instanceHasWorkflowState(final EIInstanceMinimal instance) {
		return isNotNull(instance.getWFState());
	}

	public static boolean isNotNull(final EIEntity entity) {
		return entity != null && !EIEntity.NULL_ENTITY.equals(entity);
	}

	public static boolean isPublishedOrWithdrawn(final EIInstance instance) {
		return instanceHasWorkflowState(instance) && (WorkFlowConstants.PUBLISH_ENTITY.equals(instance.getWFState()) || WorkFlowConstants.WITHDRAW_ENTITY.equals(instance.getWFState()));
	}

	public static boolean isPublishedOrWithdrawn(final EIInstanceMinimal instance) {
		return instanceHasWorkflowState(instance) && (WorkFlowConstants.PUBLISH_ENTITY.equals(instance.getWFState()) || WorkFlowConstants.WITHDRAW_ENTITY.equals(instance.getWFState()));
	}

	public static boolean getUsabilityofWidgetByWorkflowRule(EIInstance instance, final User currentUser) {
		return instanceHasWorkflowState(instance) && ((instanceHasCurrentOwner(instance, currentUser) && WorkflowUtils.canUserChangeState(instance.getWFState().getURI())) || isPublishedOrWithdrawn(instance));
	}

	public static boolean getVisibiltyofWidgetByWorkflowRule(EIInstance instance) {
		return instanceHasWorkflowState(instance) && WorkflowUtils.canUserChangeState(instance.getWFState().getURI());
	}

	public static boolean getVisibiltyofWidgetByWorkflowRuleAndState(EIInstance instance) {
		return instanceHasWorkflowState(instance) && WorkflowUtils.canUserChangeState(instance.getWFState().getURI()) && !WorkflowUtils.isPublishedOrWithdrawn(instance);
	}

	public static boolean canUserChangeState(EIURI currentWFState, EIURI newWFState) {
		Log.info("CanUSerChangeState: current = " + currentWFState + " new = " + newWFState);
		if ((currentWFState == null) || (newWFState == null))
			return false;
		List<EIURI> transitions = WorkFlowConstants.ALLOWED_TRANSITIONS.get(currentWFState);
		return ClientRepositoryToolsManager.INSTANCE.canEdit(currentWFState) && transitions.contains(newWFState);
	}
	
	public static boolean canUserChangeState(EIInstance instance, EIURI newWFState) {
		if (instance.getWFState() == null)
			return false;
		if (instance.getWFOwner() == null) // TODO: actually, need to make sure user can edit
			return false;
		return canUserChangeState(instance.getWFState().getURI(), newWFState);
	}

	public static boolean canUserChangeState(EIURI currentWFState) {
		if (currentWFState == null)
			return false;
		return ClientRepositoryToolsManager.INSTANCE.canEdit(currentWFState);
	}
}
