/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.rpc;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.InvocationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eaglei.datatools.User;
import org.eaglei.datatools.client.DatatoolsCookies;
import org.eaglei.datatools.client.WorkFlowConstants;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.rpc.RepositoryToolsModelService;
import org.eaglei.datatools.client.rpc.RepositoryToolsModelServiceAsync;
import org.eaglei.datatools.client.ui.ApplicationState;
import org.eaglei.datatools.client.ui.DatatoolsUIConstants;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIInstanceMinimal;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;
import org.eaglei.model.gwt.rpc.LoggedException;
import org.eaglei.model.gwt.rpc.ModelService;
import org.eaglei.model.gwt.rpc.ModelServiceAsync;
import org.eaglei.security.Session;

public class ClientRepositoryToolsManager {
    public static final ClientRepositoryToolsManager INSTANCE = new ClientRepositoryToolsManager();
    public static RepositoryToolsModelServiceAsync repositoryService;
    public static ModelServiceAsync modelService;
    private final HashMap<EIURI, EIInstanceMinimal> mapIdInstance = new HashMap();
    private final HashMap<EIURI, EIClass> mapIdToClass = new HashMap();
    private Session session;
    private EIEntity user;
    private ArrayList<SessionListener> listeners;
    private List<EIURI> editableStates;

    private ClientRepositoryToolsManager() {
        String userUriString = DatatoolsCookies.getUserUri();
        if (userUriString != null) {
            this.user = EIEntity.create((EIURI)EIURI.create((String)userUriString), (String)DatatoolsCookies.getUserName());
            Log.info((String)("got existing userUri: " + this.user));
        }
        this.session = DatatoolsCookies.getSession();
        if (this.session != null) {
            Log.info((String)("got session ID " + this.session.getSessionId()));
        }
        repositoryService = (RepositoryToolsModelServiceAsync)GWT.create(RepositoryToolsModelService.class);
        modelService = (ModelServiceAsync)GWT.create(ModelService.class);
    }

    public boolean isLoggedIn() {
        return Session.isValid((Session)this.session);
    }

    private void handleLogOut() {
        this.session = null;
        this.user = null;
        Cookies.removeCookie((String)"datatools_username");
        Cookies.removeCookie((String)"datatools_userUri");
        Cookies.removeCookie((String)"datatools_session");
        Log.info((String)"removed cookies");
        if (this.listeners != null) {
            for (SessionListener listener : this.listeners) {
                listener.onLogOut();
            }
        }
    }

    public void addSessionListener(SessionListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
        Log.info((String)"added listener");
    }

    public void logOut() {
        if (!this.isLoggedIn()) {
            return;
        }
        try {
            repositoryService.logout(this.session, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void logIn(String username, String password, ResultsCallback callback) {
        boolean USERNAME = false;
        if (this.isLoggedIn()) {
            try {
                repositoryService.whoami(this.session, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception e) {}
        } else {
            try {
                repositoryService.login(username, password, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateInstance(EIInstance eiInstance, String token, SaveResultsCallback callback) throws Exception {
        Log.info((String)("trying to update " + eiInstance.getInstanceLabel()));
        repositoryService.updateInstance(this.session, eiInstance, token, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getInstance(EIURI eiURI, EIInstanceCallback callback) throws Exception {
        repositoryService.getInstance(this.session, eiURI, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void deleteInstance(EIURI instanceUri, DeleteInstanceCallback callback) throws Exception {
        repositoryService.deleteInstance(this.session, instanceUri, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initializeEditableStates(User userInfo) {
        Log.info((String)("initializing editable states with " + userInfo.getWFSStateList().size() + " states"));
        this.editableStates = new ArrayList();
        for (EIURI stateURI : userInfo.getWFSStateList()) {
            this.editableStates.add(stateURI);
            Log.info((String)("adding editable state " + stateURI));
        }
    }

    public boolean canEdit(EIURI workflowState) {
        if (this.editableStates == null) {
            Log.info((String)"editable states null");
            return false;
        }
        if (workflowState == null) {
            return false;
        }
        return this.editableStates.contains(workflowState);
    }

    public List<EIURI> getEditableStates() {
        return this.editableStates;
    }

    public void getFilterQuery(EIURI userUri, EIURI classUri, EIURI state, EIURI lab, EIInstancesCallback callback) throws Exception {
        this.getFilterQuery(userUri.toString(), classUri, state, lab, false, callback);
    }

    public void getFilterQuery(EIURI userUri, EIURI classUri, EIURI state, EIURI lab, boolean strictOwnerFilter, EIInstancesCallback callback) throws Exception {
        this.getFilterQuery(userUri.toString(), classUri, state, lab, strictOwnerFilter, callback);
    }

    public void getFilterQuery(String user, EIURI classUri, EIURI state, EIURI lab, boolean strictOwnerFilter, EIInstancesCallback callback) throws Exception {
        repositoryService.getFilterQuery(this.session, classUri, state, lab, strictOwnerFilter, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void referencedByQuery(EIURI userUri, EIURI resourceUri, boolean strictOwnerFilter, EIInstancesCallback callback) throws Exception {
        repositoryService.referencedByQuery(this.session, resourceUri, strictOwnerFilter, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private EIInstanceMinimal getCached(EIInstanceMinimal c) {
        if (this.mapIdInstance.containsKey(c.getInstanceURI())) {
            return (EIInstanceMinimal)this.mapIdInstance.get(c.getInstanceURI());
        }
        this.mapIdInstance.put(c.getInstanceURI(), c);
        return c;
    }

    private void updateCached(EIInstanceMinimal instance, EIEntity workFlowState, EIEntity owner) {
        WorkFlowConstants wfc = new WorkFlowConstants();
        EIInstanceMinimal cached = this.getCached(instance);
        if (workFlowState != null && !workFlowState.equals((Object)EIEntity.NULL_ENTITY)) {
            cached.setWFState(workFlowState);
        }
        if (owner != null && !owner.equals((Object)EIEntity.NULL_ENTITY)) {
            cached.setWFOwner(owner);
        }
    }

    public void getNewInstanceID(int count, IdCallback callback) {
        try {
            repositoryService.getNewInstanceID(this.session, count, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createInstance(EIInstance instance, EIInstanceCallback callback) {
        try {
            Log.info((String)("creating instance " + instance.getEntity() + " with type " + instance.getInstanceClass()));
            repositoryService.createInstance(this.session, instance, ApplicationState.getInstance().getWorkspaceEntity(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getEmptyEIInstance(EIURI classUri, EIEntity instanceEntity, EIInstanceCallback callback) {
        repositoryService.getEmptyEIInstance(this.session, classUri, instanceEntity, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getEmptyEIInstance(EIURI classUri, EIInstanceCallback callback) {
        repositoryService.getEmptyEIInstance(this.session, classUri, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void deepCopyInstance(EIURI originalUri, EIInstanceCallback callback) {
        try {
            repositoryService.deepCopy(this.session, originalUri, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            Log.error((String)e.getMessage());
        }
    }

    public void query(String sparql, AsyncCallback<StringBuffer> callback) throws Exception {
    }

    public void isOnline(AsyncCallback callback) throws Exception {
    }

    public void whoami(UserCallback callback) throws Exception {
        if (repositoryService == null) {
            repositoryService = (RepositoryToolsModelServiceAsync)GWT.create(RepositoryToolsModelService.class);
        }
        Session session = DatatoolsCookies.getSession();
        repositoryService.whoami(session, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void returnToDraft(EIInstance instance, ResultsCallback callback) throws Exception {
        this.promote(instance, WorkFlowConstants.DRAFT_ENTITY, callback);
    }

    public void sendToCuration(EIInstance instance, ResultsCallback callback) throws Exception {
        this.promote(instance, WorkFlowConstants.CURATION_ENTITY, callback);
    }

    public void publish(EIInstance instance, ResultsCallback callback) throws Exception {
        this.promote(instance, WorkFlowConstants.PUBLISH_ENTITY, callback);
    }

    public void withdraw(EIInstance instance, ResultsCallback callback) throws Exception {
        Log.info((String)("withdrawing " + instance));
        this.promote(instance, WorkFlowConstants.WITHDRAW_ENTITY, callback);
    }

    public void withdraw(EIInstanceMinimal instance, ResultsCallback callback) throws Exception {
        Log.info((String)("withdrawing " + instance));
        this.promote(instance, WorkFlowConstants.WITHDRAW_ENTITY, callback);
    }

    public void bulkPublish(List<EIInstanceMinimal> instancesToPromote, ResultsCallback callback) throws Exception {
        this.bulkPromote(instancesToPromote, WorkFlowConstants.PUBLISH_ENTITY, callback);
    }

    public void bulkWithdraw(List<EIInstanceMinimal> instancesToPromote, ResultsCallback callback) throws Exception {
        this.bulkPromote(instancesToPromote, WorkFlowConstants.WITHDRAW_ENTITY, callback);
    }

    public void bulkReturnToDraft(List<EIInstanceMinimal> instancesToPromote, ResultsCallback callback) throws Exception {
        this.bulkPromote(instancesToPromote, WorkFlowConstants.DRAFT_ENTITY, callback);
    }

    public void bulkSendToCuration(List<EIInstanceMinimal> instancesToPromote, ResultsCallback callback) throws Exception {
        this.bulkPromote(instancesToPromote, WorkFlowConstants.CURATION_ENTITY, callback);
    }

    public void promote(EIInstance instance, EIEntity newState, ResultsCallback callback) throws Exception {
        if (this.isLoggedIn()) {
            Log.info((String)("promoting '" + instance.getInstanceURI().toString() + "' to " + newState));
            repositoryService.promote(this.session, instance.getInstanceURI(), newState.getURI(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void promote(EIInstanceMinimal instance, EIEntity newState, ResultsCallback callback) throws Exception {
        if (this.isLoggedIn()) {
            Log.info((String)("promoting '" + instance.getInstanceURI().toString() + "' to " + newState));
            repositoryService.promote(this.session, instance.getInstanceURI(), newState.getURI(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void bulkPromote(List<EIInstanceMinimal> instancesToPromote, EIEntity newState, ResultsCallback callback) throws Exception {
        if (this.isLoggedIn()) {
            ArrayList<EIURI> urisToPromote = new ArrayList<EIURI>(instancesToPromote.size());
            for (EIInstanceMinimal instance : instancesToPromote) {
                urisToPromote.add(instance.getInstanceURI());
            }
            repositoryService.bulkPromote(this.session, urisToPromote, newState.getURI(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void claim(EIInstanceMinimal instance, String claimant, ResultsCallback callback) throws Exception {
        if (this.isLoggedIn()) {
            Log.info((String)("Calling claim on " + instance.getInstanceLabel() + ": " + instance.getInstanceURI().toString()));
            repositoryService.claim(this.session, instance.getInstanceURI(), claimant, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void claim(EIInstanceMinimal[] instances, String claimant, ResultsCallback callback) throws Exception {
        EIURI[] eiuriArray = new EIURI[instances.length];
        int i = 0;
        for (EIInstanceMinimal instance : instances) {
            eiuriArray[i++] = instance.getInstanceURI();
        }
        if (this.isLoggedIn()) {
            repositoryService.claim(this.session, eiuriArray, claimant, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void getWFStates(String user, WFCallback callback) throws Exception {
        repositoryService.getWFStates(this.session, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void retrieveLabel(EIURI uri, ResultsCallback callback) {
        repositoryService.retrieveLabel(this.session, uri, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void retrieveLabels(List<EIEntity> entityList, LabelsCallback callback) {
        try {
            repositoryService.retrieveLabels(this.session, entityList, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void retrieveUriLabels(List<EIURI> entityList, UriLabelsCallback callback) {
        try {
            repositoryService.retrieveUriLabels(this.session, entityList, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getRootSuperclassForInstanceUri(EIURI instanceUri, ClientModelManager.ClassCallback callback) {
        try {
            repositoryService.getRootSuperclassForInstanceUri(this.session, instanceUri, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            Log.error((String)"modelService.getRootSuperclassForInstanceUri threw exception", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void getClassAndSuperclassesForInstanceUri(EIURI instanceUri, EIClassesCallback callback) {
        try {
            repositoryService.getClassAndSuperclassesForInstanceUri(this.session, instanceUri, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            Log.error((String)"modelService.getSuperclassesForInstanceUri threw exception", (Throwable)e);
            e.printStackTrace();
            callback.onFailure(e.toString());
        }
    }

    private void handleFailure(LoginRequiredCallback callback, Throwable arg0) {
        if (!(arg0 instanceof IncompatibleRemoteServiceException) && !(arg0 instanceof InvocationException)) {
            if (arg0 instanceof LoggedException) {
                if (arg0.getMessage().contains("No session information was found")) {
                    callback.loginRequired();
                } else {
                    Window.alert((String)arg0.getMessage());
                }
            } else {
                callback.loginRequired();
            }
        }
    }

    public void getSuperClass(EIClass eclass, ClientModelManager.ClassCallback callback) {
        repositoryService.getSuperClass(eclass, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getRootSuperClass(EIClass eclass, ClientModelManager.ClassCallback callback) {
        repositoryService.getRootSuperClass(eclass, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getLabRootSuperclass(ClientModelManager.ClassCallback callback) {
        if (this.mapIdToClass.containsKey(DatatoolsUIConstants.EI_LAB_URI)) {
            callback.onSuccess((EIClass)this.mapIdToClass.get(DatatoolsUIConstants.EI_LAB_URI));
        } else {
            modelService.getClass(DatatoolsUIConstants.EI_LAB_URI, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void getEquivalentClasses(List<EIProperty> propertiesToPopulate, EquivalentClassesCallback callback) {
        repositoryService.getAllEquivalentClasses(propertiesToPopulate, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ void access$000(ClientRepositoryToolsManager x0) {
        x0.handleLogOut();
    }

    static /* synthetic */ Session access$102(ClientRepositoryToolsManager x0, Session x1) {
        x0.session = x1;
        return x0.session;
    }

    static /* synthetic */ EIEntity access$202(ClientRepositoryToolsManager x0, EIEntity x1) {
        x0.user = x1;
        return x0.user;
    }

    static /* synthetic */ Session access$100(ClientRepositoryToolsManager x0) {
        return x0.session;
    }

    static /* synthetic */ void access$300(ClientRepositoryToolsManager x0, User x1) {
        x0.initializeEditableStates(x1);
    }

    static /* synthetic */ ArrayList access$400(ClientRepositoryToolsManager x0) {
        return x0.listeners;
    }

    static /* synthetic */ void access$500(ClientRepositoryToolsManager x0, LoginRequiredCallback x1, Throwable x2) {
        x0.handleFailure(x1, x2);
    }

    static /* synthetic */ void access$600(ClientRepositoryToolsManager x0, EIInstanceMinimal x1, EIEntity x2, EIEntity x3) {
        x0.updateCached(x1, x2, x3);
    }

    static /* synthetic */ EIEntity access$200(ClientRepositoryToolsManager x0) {
        return x0.user;
    }

    static /* synthetic */ HashMap access$700(ClientRepositoryToolsManager x0) {
        return x0.mapIdToClass;
    }
}

