/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui.widgets;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eaglei.datatools.client.rpc.ClientRepositoryToolsManager;
import org.eaglei.datatools.client.ui.WidgetUtils;
import org.eaglei.datatools.client.ui.widgets.EIResourceWidget;
import org.eaglei.datatools.client.ui.widgets.EditWidget;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;
import org.eaglei.model.gwt.rpc.ClientModelManager;

public class ObjectWidget
extends EditWidget {
    private ListBox rangePicker = new ListBox();
    private List<EIClass> rangeList = new ArrayList();
    private EIEntity selectedEntity;
    private EIClass instanceRootClass;
    private List<EIClass> instanceSuperclasses;
    private EditWidget innerWidget;
    private EIEntity labEntity;
    private boolean isEnabled = true;
    private Map<EIEntity, EIClass> entityRangeMap = new HashMap();
    private static final String NO_VALUE = "<none>";

    public ObjectWidget(EIInstance eiInstance, EIEntity propertyEntity, String propertyDefinition, boolean isRequired, List<EIClass> rangeList, EIEntity labEntity, EIEntity selectedEntity) {
        super(eiInstance, propertyEntity, propertyDefinition, isRequired);
        Log.info((String)("range list has " + rangeList.size() + " entries"));
        this.rangeList = rangeList;
        this.selectedEntity = selectedEntity;
        Log.info((String)("selected entity is: " + this.selectedEntity));
        this.labEntity = labEntity;
        this.getInstanceRootClass();
    }

    private void setup() {
        this.widgetPanel.add((Widget)this.rangePicker);
        this.rangePicker.addItem(NO_VALUE, NO_VALUE);
        for (EIClass range : this.rangeList) {
            this.entityRangeMap.put(range.getEntity(), range);
            this.rangePicker.addItem(range.getEntity().getLabel(), range.getEntity().getURI().toString());
            if (this.instanceRootClass == null && this.instanceSuperclasses != null && this.instanceSuperclasses.contains(range)) {
                Log.info((String)("selecting range: " + range));
                this.rangePicker.setSelectedIndex(this.rangePicker.getItemCount() - 1);
                continue;
            }
            if (this.instanceRootClass != null && range.getEntity().equals((Object)this.instanceRootClass.getEntity())) {
                Log.info((String)("selecting range with instanceRootClass: " + range));
                this.rangePicker.setSelectedIndex(this.rangePicker.getItemCount() - 1);
                continue;
            }
            if (!this.hasLabUri() || !WidgetUtils.isLabProperty((EIClass)range)) continue;
            Log.info((String)("selecting lab property " + range));
            this.rangePicker.setSelectedIndex(this.rangePicker.getItemCount() - 1);
        }
        if (this.rangePicker.getSelectedIndex() > 0) {
            EIEntity selectedRange = this.getSelectedRangeEntity();
            if (((EIClass)this.entityRangeMap.get(selectedRange)).isEagleIResource()) {
                if (this.selectedEntity == null && this.hasLabUri() && WidgetUtils.isLabProperty((EIEntity)selectedRange)) {
                    Log.info((String)("making lab-property for " + this.entityRangeMap.get(selectedRange) + " " + this.labEntity));
                    this.eiInstance.addObjectProperty(this.propertyEntity, this.labEntity);
                    this.innerWidget = new EIResourceWidget(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, (EIClass)this.entityRangeMap.get(selectedRange), this.labEntity, false);
                    this.disable();
                } else {
                    Log.info((String)"no lab");
                    this.innerWidget = new EIResourceWidget(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, (EIClass)this.entityRangeMap.get(selectedRange), this.selectedEntity, false);
                }
                this.widgetPanel.add((Widget)this.innerWidget);
            } else {
                HorizontalPanel tempPanel = new HorizontalPanel();
                this.widgetPanel.add((Widget)tempPanel);
                WidgetUtils.addTermWidgetToPanel((EIInstance)this.eiInstance, (EIEntity)this.propertyEntity, (String)this.propertyDefinition, (boolean)this.isRequired, (EIClass)this.instanceRootClass, (EIEntity)this.selectedEntity, (HorizontalPanel)tempPanel, (boolean)false);
            }
        } else if (this.selectedEntity != null && this.selectedEntity != EIEntity.NULL_ENTITY) {
            Log.info((String)"trying to make widget for deleted value");
            this.innerWidget = new EIResourceWidget(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, EIClass.NULL_CLASS, this.selectedEntity, false);
            this.widgetPanel.add((Widget)this.innerWidget);
        }
        this.rangePicker.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void getInstanceRootClass() {
        if (this.selectedEntity == null) {
            Log.info((String)"no selected entity");
            this.setup();
            return;
        }
        if (WidgetUtils.isInstanceUri((String)this.selectedEntity.getURI().toString())) {
            Log.info((String)("Trying to get superclasses for instance: " + this.selectedEntity));
            ClientRepositoryToolsManager.INSTANCE.getClassAndSuperclassesForInstanceUri(this.selectedEntity.getURI(), (ClientRepositoryToolsManager.EIClassesCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            Log.info((String)("in getInstanceRootClass for " + this.selectedEntity));
            ClientModelManager.INSTANCE.getClass(this.selectedEntity.getURI(), (ClientModelManager.ClassCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private EIEntity getSelectedRangeEntity() {
        return WidgetUtils.getSelectedEntity((ListBox)this.rangePicker);
    }

    @Deprecated
    private EIURI getSelectedRangeUri() {
        return WidgetUtils.getSelectedUri((ListBox)this.rangePicker);
    }

    protected EditWidget getInnerWidget() {
        if (this.innerWidget != null) {
            return this.innerWidget;
        }
        if (this.widgetPanel.getWidgetCount() > 2) {
            Widget widget = this.widgetPanel.getWidget(2);
            if (widget instanceof HorizontalPanel && (widget = ((HorizontalPanel)widget).getWidget(0)) != null) {
                return (EditWidget)widget;
            }
            if (widget instanceof EditWidget) {
                EditWidget inner = (EditWidget)widget;
                return inner;
            }
            Window.alert((String)"Failed to get an editWidget");
        }
        return null;
    }

    protected boolean hasOldValue() {
        return this.getInnerWidget().hasOldValue();
    }

    protected void removeValue() {
        this.getInnerWidget().removeValue();
    }

    public EditWidget duplicateBlank() {
        return new ObjectWidget(this.eiInstance, this.propertyEntity, this.propertyDefinition, this.isRequired, this.rangeList, this.labEntity, null);
    }

    protected boolean hasLabUri() {
        return this.labEntity != null && !this.labEntity.getURI().toString().equals("");
    }

    public void disable() {
        this.rangePicker.setEnabled(false);
        if (this.innerWidget instanceof EIResourceWidget) {
            ((EIResourceWidget)this.innerWidget).disable();
        }
        this.isEnabled = false;
    }

    public boolean isDisabled() {
        return !this.isEnabled;
    }

    static /* synthetic */ ListBox access$000(ObjectWidget x0) {
        return x0.rangePicker;
    }

    static /* synthetic */ EditWidget access$102(ObjectWidget x0, EditWidget x1) {
        x0.innerWidget = x1;
        return x0.innerWidget;
    }

    static /* synthetic */ EIEntity access$200(ObjectWidget x0) {
        return x0.getSelectedRangeEntity();
    }

    static /* synthetic */ Map access$300(ObjectWidget x0) {
        return x0.entityRangeMap;
    }

    static /* synthetic */ EditWidget access$100(ObjectWidget x0) {
        return x0.innerWidget;
    }

    static /* synthetic */ List access$402(ObjectWidget x0, List x1) {
        x0.instanceSuperclasses = x1;
        return x0.instanceSuperclasses;
    }

    static /* synthetic */ List access$400(ObjectWidget x0) {
        return x0.instanceSuperclasses;
    }

    static /* synthetic */ void access$500(ObjectWidget x0) {
        x0.setup();
    }

    static /* synthetic */ EIClass access$602(ObjectWidget x0, EIClass x1) {
        x0.instanceRootClass = x1;
        return x0.instanceRootClass;
    }
}

