/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.datatools.client.ui;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import java.util.ArrayList;
import org.eaglei.datatools.client.event.BrowserBackOrForwardEvent;
import org.eaglei.datatools.client.logging.GWTLogger;
import org.eaglei.datatools.client.ui.ApplicationStateChangeListener;
import org.eaglei.datatools.client.ui.LabCache;
import org.eaglei.datatools.client.ui.QueryTokenObject;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;
import org.eaglei.ui.gwt.instance.widgets.InstanceWidgetUtils;

public class ApplicationState
implements ValueChangeHandler<String> {
    private final QueryTokenObject queryTokenObject;
    private static ApplicationState applicationState;
    private final HandlerManager handlerManager = new HandlerManager((Object)this);
    private String sessionID;
    private EIEntity user;
    private final ArrayList<ApplicationStateChangeListener> listeners;
    private final LabCache labCache;
    private static final GWTLogger log;

    public static ApplicationState getInstance() {
        if (applicationState == null) {
            log.info("making new application state");
            if (!Window.Location.getHash().equals("")) {
                log.info("making app state with hash");
                applicationState = new ApplicationState(Window.Location.getHash());
            } else {
                log.info("making app state without hash");
                applicationState = new ApplicationState();
            }
        }
        return applicationState;
    }

    private ApplicationState() {
        this.queryTokenObject = new QueryTokenObject();
        this.listeners = new ArrayList();
        History.addValueChangeHandler((ValueChangeHandler)this);
        this.labCache = new LabCache();
        this.update();
    }

    private ApplicationState(String bookmark) {
        this.queryTokenObject = new QueryTokenObject(bookmark);
        this.listeners = new ArrayList();
        History.addValueChangeHandler((ValueChangeHandler)this);
        this.labCache = new LabCache();
    }

    public QueryTokenObject.Mode getMode() {
        return this.queryTokenObject.getMode();
    }

    public void setMode(QueryTokenObject.Mode newMode) {
        this.queryTokenObject.setMode(newMode);
        this.update();
    }

    public EIEntity getInstanceEntity() {
        return this.queryTokenObject.getInstanceEntity();
    }

    public EIURI getInstanceUri() {
        return this.getInstanceEntity().getURI();
    }

    public void setInstanceEntity(EIEntity newEntity) {
        this.queryTokenObject.setInstanceEntity(this.getCorrectEntity(newEntity));
        this.update();
    }

    public boolean hasInstance() {
        return this.getCorrectEntity(this.getInstanceEntity()) != EIEntity.NULL_ENTITY;
    }

    public EIEntity getTypeEntity() {
        return this.queryTokenObject.getTypeEntity();
    }

    public EIURI getTypeUri() {
        return this.queryTokenObject.getTypeEntity().getURI();
    }

    private void setTypeEntity(EIEntity typeEntity) {
        this.queryTokenObject.setTypeEntity(this.getCorrectEntity(typeEntity));
        this.update();
    }

    public EIEntity getLabEntity() {
        return this.getCorrectEntity(this.queryTokenObject.getLabEntity());
    }

    public EIURI getLabUri() {
        return this.getLabEntity().getURI();
    }

    public void setLabEntity(EIEntity labEntity) {
        this.queryTokenObject.setLabEntity(this.getCorrectEntity(labEntity));
        this.update();
    }

    public EIEntity getFilterTypeEntity() {
        return this.queryTokenObject.getFilterTypeEntity();
    }

    public EIURI getFilterTypeUri() {
        return this.getFilterTypeEntity().getURI();
    }

    public boolean hasFilterTypeEntity() {
        return this.getFilterTypeEntity() != EIEntity.NULL_ENTITY;
    }

    private void setFilterTypeEntity(EIEntity filterTypeEntity) {
        this.queryTokenObject.setFilterTypeEntity(this.getCorrectEntity(filterTypeEntity));
        this.update();
    }

    public EIEntity getFilterLabEntity() {
        return this.queryTokenObject.getFilterLabEntity();
    }

    public EIURI getFilterLabUri() {
        return this.getFilterLabEntity().getURI();
    }

    public void setFilterLabEntity(EIEntity filterLabEntity) {
        this.queryTokenObject.setFilterLabEntity(filterLabEntity);
        this.update();
    }

    public EIEntity getFilterWorkflowEntity() {
        return this.queryTokenObject.getFilterWorkflowEntity();
    }

    public EIURI getFilterWorkflowUri() {
        return this.getFilterWorkflowEntity().getURI();
    }

    public void setFilterWorkflowEntity(EIEntity filterWorkflowEntity) {
        this.queryTokenObject.setFilterWorkflowEntity(filterWorkflowEntity);
        this.update();
    }

    public boolean isStrictlyFilteredByOwner() {
        return this.queryTokenObject.isStrictlyFilteredByOwner();
    }

    public void setStrictFilterByOwner(boolean filterByOwner) {
        this.queryTokenObject.setStrictFilterByOwner(filterByOwner);
        this.update();
    }

    public EIEntity getWorkspaceEntity() {
        return this.queryTokenObject.getWorkspaceEntity();
    }

    public void setWorkspaceEntity(EIEntity workspaceEntity) {
        this.queryTokenObject.setWorkspaceEntity(workspaceEntity);
        this.update();
    }

    public boolean hasType() {
        return this.getCorrectEntity(this.getTypeEntity()) != EIEntity.NULL_ENTITY;
    }

    public boolean hasLab() {
        return this.getCorrectEntity(this.getLabEntity()) != EIEntity.NULL_ENTITY;
    }

    public boolean hasLabType() {
        return InstanceWidgetUtils.isLabProperty((EIEntity)this.getTypeEntity());
    }

    public void onValueChange(ValueChangeEvent<String> event) {
        this.handlerManager.fireEvent((GwtEvent)new BrowserBackOrForwardEvent(this.queryTokenObject));
        log.info("history change event value '" + (String)event.getValue() + "'");
        this.queryTokenObject.fromString((String)event.getValue());
        this.notifyListeners();
    }

    private void notifyListeners() {
        for (ApplicationStateChangeListener listener : this.listeners) {
            listener.onApplicationStateChange();
        }
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getUserID() {
        return this.user.getLabel();
    }

    public EIURI getUserURI() {
        return this.user.getURI();
    }

    public EIEntity getUser() {
        return this.user;
    }

    public void setUser(EIEntity userEntity) {
        this.user = userEntity == null ? EIEntity.NULL_ENTITY : userEntity;
    }

    public void updateApplicationState(QueryTokenObject.Mode mode, EIEntity instanceEntity, EIEntity typeEntity, EIEntity labEntity) {
        this.updateApplicationState(mode, instanceEntity, typeEntity, labEntity, false);
    }

    public void updateApplicationState(QueryTokenObject.Mode mode, EIEntity instanceEntity, EIEntity typeEntity, EIEntity labEntity, boolean updateFilterEntities) {
        this.queryTokenObject.setMode(mode);
        this.queryTokenObject.setInstanceEntity(this.getCorrectEntity(instanceEntity));
        this.queryTokenObject.setTypeEntity(this.getCorrectEntity(typeEntity));
        this.queryTokenObject.setLabEntity(this.getCorrectEntity(labEntity));
        this.queryTokenObject.setFilterWorkflowEntity(EIEntity.NULL_ENTITY);
        this.queryTokenObject.setFilterLabEntity(updateFilterEntities ? this.getCorrectEntity(labEntity) : EIEntity.NULL_ENTITY);
        this.queryTokenObject.setFilterTypeEntity(updateFilterEntities ? this.getCorrectEntity(typeEntity) : EIEntity.NULL_ENTITY);
        this.queryTokenObject.setStrictFilterByOwner(false);
        this.update();
    }

    public void updatePaging(String sortColumn, Integer offset, Integer limit) {
        this.queryTokenObject.setSortBy(sortColumn);
        this.queryTokenObject.setOffset(offset);
        this.queryTokenObject.setLimit(limit);
        this.update();
    }

    public void updateToDefaultPaging() {
        this.queryTokenObject.setDefaultPagination();
        this.update();
    }

    public Integer getOffset() {
        return this.queryTokenObject.getOffset();
    }

    public Integer getLimit() {
        return this.queryTokenObject.getLimit();
    }

    public String getSortBy() {
        return this.queryTokenObject.getSortBy();
    }

    public void updateApplicationFilterState(EIEntity filterTypeEntity, EIEntity filterWorkflowEntity, EIEntity filterLabEntity, boolean strictlyFilteredByOwner) {
        this.queryTokenObject.setMode(QueryTokenObject.Mode.filter);
        this.queryTokenObject.setFilterTypeEntity(this.getCorrectEntity(filterTypeEntity));
        this.queryTokenObject.setFilterWorkflowEntity(this.getCorrectEntity(filterWorkflowEntity));
        this.queryTokenObject.setFilterLabEntity(this.getCorrectEntity(filterLabEntity));
        this.queryTokenObject.setStrictFilterByOwner(strictlyFilteredByOwner);
        this.update();
    }

    public void refresh() {
        History.fireCurrentHistoryState();
    }

    private void update() {
        History.newItem((String)this.queryTokenObject.toString(), (boolean)false);
        this.notifyListeners();
    }

    public boolean hasUser() {
        return this.getCorrectEntity(this.user) != EIEntity.NULL_ENTITY;
    }

    public void addApplicationStateListener(ApplicationStateChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeApplicationStateListener(ApplicationStateChangeListener listener) {
        this.listeners.remove(listener);
    }

    private EIEntity getCorrectEntity(EIEntity entity) {
        return entity == null ? EIEntity.NULL_ENTITY : entity;
    }

    public boolean hasFilters() {
        return this.getCorrectEntity(this.getFilterTypeEntity()) != EIEntity.NULL_ENTITY || this.getCorrectEntity(this.getFilterWorkflowEntity()) != EIEntity.NULL_ENTITY || this.getCorrectEntity(this.getFilterLabEntity()) != EIEntity.NULL_ENTITY;
    }

    public void clearApplicationState() {
        this.queryTokenObject.fromString("");
    }

    public boolean isPaginated() {
        return this.queryTokenObject.isPaginated();
    }

    public LabCache getLabCache() {
        return this.labCache;
    }

    public void updateLabCache() {
        this.labCache.update();
    }

    static {
        log = GWTLogger.getLogger((String)"ApplicationState");
    }
}

