/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.lexical.lucene;

import org.eaglei.lexical.EntityMatch;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIURI;

public final class EntityMatchImpl
implements EntityMatch {
    private String highlight;
    private String matchLabel;
    private EIEntity entity;
    private String rootTypeLabel;
    private float score;

    public EntityMatchImpl(String prefLabel, String matchLabel, String highlight, String URI, float score) {
        assert (prefLabel != null);
        assert (highlight != null);
        assert (matchLabel != null);
        assert (URI != null);
        assert (score >= 0.0f);
        this.entity = EIEntity.create((EIURI)EIURI.create((String)URI), (String)prefLabel);
        this.highlight = highlight;
        this.matchLabel = matchLabel;
        this.score = score;
    }

    public EIEntity getEntity() {
        return this.entity;
    }

    public float getScore() {
        return this.score;
    }

    public String getHighlight() {
        return this.highlight;
    }

    public String getMatchLabel() {
        return this.matchLabel;
    }

    public void setRootTypeLabel(String rootTypeLabel) {
        this.rootTypeLabel = rootTypeLabel;
    }

    public String getRootTypeLabel() {
        return this.rootTypeLabel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.highlight);
        sb.append(" (");
        sb.append(this.entity);
        sb.append(", ");
        sb.append(this.score);
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        return this.entity.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof EntityMatchImpl)) {
            return false;
        }
        return ((EntityMatchImpl)other).entity.equals((Object)this.entity);
    }
}

