/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.lexical.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.eaglei.lexical.EntityExtractionProvider;
import org.eaglei.lexical.EntityMatch;
import org.eaglei.lexical.EntityMatchRequest;
import org.eaglei.lexical.lucene.EntityMatchImpl;
import org.eaglei.lexical.lucene.LuceneUtils;
import org.eaglei.model.EIURI;

public class LuceneEntityExtractionProvider
implements EntityExtractionProvider {
    private static final Log logger = LogFactory.getLog(LuceneEntityExtractionProvider.class);
    public static final float DEFAULT_SCORE_THRESHHOLD = 0.2f;
    public static final int MAX_FRAGMENTS = 4;
    private QueryParser labelParser;
    private IndexSearcher searcher;
    private Analyzer queryAnalyzer;
    private Analyzer indexAnalyzer;
    private float scoreThreshold = 0.2f;
    private boolean fuzzyRewrite = false;

    public LuceneEntityExtractionProvider(Analyzer analyzer, Directory directory) throws IOException {
        this(analyzer, analyzer, directory);
    }

    public LuceneEntityExtractionProvider(Analyzer queryAnalyzer, Analyzer indexAnalyzer, Directory directory) throws IOException {
        this.searcher = this.createSearcher(directory);
        this.labelParser = new QueryParser(Version.LUCENE_30, "label", queryAnalyzer);
        this.queryAnalyzer = queryAnalyzer;
        this.indexAnalyzer = indexAnalyzer;
    }

    public void setFuzzyRewrite(boolean fuzzyRewrite) {
        this.fuzzyRewrite = fuzzyRewrite;
    }

    public void setScoreThreshold(float threshold) {
        this.scoreThreshold = threshold;
    }

    public List<EntityMatch> match(EntityMatchRequest request) throws IOException {
        ArrayList<EntityMatch> matches = new ArrayList<EntityMatch>();
        String text = request.getText();
        if (text == null || text.length() == 0) {
            return matches;
        }
        try {
            Query query = this.parse(request);
            TopFieldDocs docs = this.search(query, request.getMaxMatches());
            if (docs.totalHits == 0 && this.fuzzyRewrite) {
                query = LuceneUtils.rewriteToFuzzy(query);
                docs = this.search(query, request.getMaxMatches());
            }
            Highlighter highlighter = new Highlighter((Scorer)new QueryScorer(query));
            for (int i = 0; i < docs.scoreDocs.length && i < request.getMaxMatches(); ++i) {
                Field[] labels;
                ScoreDoc scoreDoc = docs.scoreDocs[i];
                Document document = this.searcher.doc(scoreDoc.doc);
                float score = scoreDoc.score;
                if (!(this.scoreThreshold <= 0.0f) && !(score >= this.scoreThreshold)) continue;
                String label = null;
                String highlight = null;
                String prefLabel = document.get("pref_label");
                for (Field field : labels = document.getFields("label")) {
                    label = field.stringValue();
                    try {
                        highlight = highlighter.getBestFragment(this.indexAnalyzer, "label", label);
                        if (highlight == null) continue;
                        break;
                    }
                    catch (InvalidTokenOffsetsException itoe) {
                        logger.error((Object)itoe);
                    }
                    catch (IOException ioe) {
                        logger.error((Object)ioe);
                    }
                }
                if (highlight == null) {
                    logger.warn((Object)("Could not find highlight for " + label));
                    highlight = label = document.get("pref_label");
                }
                EntityMatchImpl match = new EntityMatchImpl(prefLabel, label, highlight, document.get("uri"), score);
                matches.add(match);
            }
        }
        catch (ParseException pe) {
            throw new IOException(pe);
        }
        return matches;
    }

    private IndexSearcher createSearcher(Directory directory) throws IOException {
        IndexSearcher searcher = new IndexSearcher(directory, true);
        searcher.setDefaultFieldSortScoring(true, true);
        return searcher;
    }

    private Query parse(EntityMatchRequest request) throws ParseException {
        BooleanQuery query = new BooleanQuery();
        String text = request.getText();
        EIURI uri = request.getURI();
        Query labelQuery = LuceneUtils.escapeIfInvalid(this.labelParser, text);
        query.add(labelQuery, BooleanClause.Occur.MUST);
        if (uri != null) {
            PhraseQuery typeQuery = new PhraseQuery();
            typeQuery.add(new Term("type", uri.toString()));
            query.add((Query)typeQuery, BooleanClause.Occur.MUST);
        }
        return query;
    }

    private TopFieldDocs search(Query query, int maxMatches) throws IOException, ParseException {
        assert (this.searcher != null);
        return this.searcher.search(query, null, maxMatches, Sort.RELEVANCE);
    }
}

