/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.lexical.lucene;

import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class LuceneUtils {
    public static Query escapeIfInvalid(QueryParser parser, String query) throws ParseException {
        assert (parser != null);
        assert (query != null);
        try {
            return parser.parse(query);
        }
        catch (ParseException pe) {
            return parser.parse(QueryParser.escape((String)query));
        }
    }

    public static Query rewriteToFuzzy(Query originalQuery) {
        if (originalQuery instanceof BooleanQuery) {
            BooleanClause[] clauses;
            BooleanQuery bq = (BooleanQuery)originalQuery;
            for (BooleanClause clause : clauses = bq.getClauses()) {
                Query q = clause.getQuery();
                if (!(clause.getQuery() instanceof TermQuery) && !(clause.getQuery() instanceof PhraseQuery) || clause.getOccur().equals((Object)BooleanClause.Occur.MUST_NOT) || !(clause.getQuery() instanceof TermQuery)) continue;
                TermQuery tq = (TermQuery)q;
                FuzzyQuery fq = new FuzzyQuery(tq.getTerm());
                clause.setQuery((Query)fq);
            }
            return bq;
        }
        if (originalQuery instanceof TermQuery) {
            TermQuery tq = (TermQuery)originalQuery;
            FuzzyQuery fq = new FuzzyQuery(tq.getTerm());
            return fq;
        }
        return originalQuery;
    }
}

