package org.eaglei.model;

import java.io.Serializable;

public class EIURI implements Serializable {

    public static final long serialVersionUID = 1L;

    private String id;

    /*
     * Disallow use of no-arg constructor
     */
    private EIURI() {
        // for GWT
    }

    // Use static create()
    private EIURI(String id) {
        this.id = id;
    }

    public static EIURI create(String id) {
        // Can add intern'ing
        return new EIURI(id);
    }

    @Override
    public boolean equals(Object ob) {
        if (ob == this)
            return true;
        if (!(ob instanceof EIURI))
            return false;
        EIURI that = (EIURI) ob;
        return this.id.equals(that.id);
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }

    @Override
    public String toString() {
        return id;
    }

}
