/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model;

import java.io.Serializable;
import org.eaglei.model.EIURI;

public class EIEntity
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final String NO_LABEL = "<none>";
    public static final EIEntity NULL_ENTITY = EIEntity.create(EIURI.create("none"), "<none>");
    private EIURI uri;
    private String label;

    public void setLabel(String label) {
        this.label = label;
    }

    private EIEntity() {
    }

    private EIEntity(EIURI uri, String label) {
        assert (uri != null) : "URI must be non-null: uri [" + uri + "] label [" + label + "]";
        this.uri = uri;
        this.label = label != null ? label : NO_LABEL;
    }

    public static EIEntity create(String strURI, String label) {
        return new EIEntity(EIURI.create(strURI), label);
    }

    public static EIEntity create(EIURI uri, String label) {
        return new EIEntity(uri, label);
    }

    public EIURI getURI() {
        return this.uri;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof EIEntity) {
            EIEntity other = (EIEntity)o;
            return other.getURI().equals(this.getURI());
        }
        return false;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return this.label + " : " + this.uri.toString();
    }
}

