package org.eaglei.model;

import java.util.List;

/**
 * This data structure represents equivalence information.
 * It is not an EIClass itself.
 * 
 * @author Ted
 *
 */
public class EIEquivalentClass {
    
    // May be null, do we even need it?
    private String uri;
    private List<EIClass> equivalentTo;
    
    public EIEquivalentClass(String uri, List<EIClass> equivalentTo) {
        this.setURI(uri);
        this.setEquivalentTo(equivalentTo);
    }

    public void setURI(String uri) {
        // May be null.
        this.uri = uri;
    }

    /**
     * URI of the equivalent class data structure itself.
     * Use getEquivalentTo() to get the list of EIClasses that
     * this data structure represents equivalence to.
     * 
     * @return uri string.  May be null.
     */
    public String getURI() {
        // May be null.
        return uri;
    }

    /**
     * Gets the List of EIClasses that this data structure expresses equivalence to.
     * 
     * @return
     */
    public List<EIClass> getEquivalentTo() {
        return equivalentTo;
    }

    public void setEquivalentTo(List<EIClass> equivalentTo) {
        this.equivalentTo = equivalentTo;
    }

}
