package org.eaglei.model;

import java.io.Serializable;

public abstract class EIOntResource extends EIResource implements Serializable {

    public static final String NO_DEFINITION = "NO DEFINITION";

    private transient String definition = null;

    protected EIOntResource() {
        // for GWT
    }

    protected EIOntResource(EIEntity entity) {
        super(entity);
    }

    /**
     * A class definition string.  
     * Null if a definition has not yet been set.
     * Non-null if setDefintion() has been called.  Note that if a class
     * has no definition string available in the ontology,
     * this field will be set to NO_DEFINITION.
     * 
     * @return
     */
    public String getDefinition() {
        return definition;
    }
    
    /**
     * Sets a definition string for this class.
     * Must not be null.  If no definition is available,
     * set this field to NO_DEFINITION.
     * 
     * @param definition
     */
    public void setDefinition(String definition) {
        if (definition == null) {
            this.definition = NO_DEFINITION;
        } else {
            this.definition = definition;
        }
    }

}
