package org.eaglei.model;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Temporary data structure for associating and instance with a set of instances
 * that reference it. Need to bundle them together to support on-the-fly inverse
 * property inferencing.
 * 
 * Eventually, will probably want these to be retrieved independently.
 * 
 * @author Ted
 * 
 */
public class EIInstanceX implements Serializable {

	public EIInstance instance;
	public List<EIInstanceMinimal> references;
	// Map of any terms used as object property values
	// in this instance to their definitions
	// Used both to identify terms and supply tooltips
	// May be null
	public Map<EIURI, String> mapTermToDefinition;

	private EIInstanceX() {
		// for GWT
	}

	public EIInstanceX(EIInstance instance, List<EIInstanceMinimal> references,
			Map<EIURI, String> mapTermToDefinition) {
		this.instance = instance;
		this.references = references;
		this.mapTermToDefinition = mapTermToDefinition;
	}
}
