/**
 * The eagle-i consortium
 * Harvard University
 * Nov 5, 2010
 */
package org.eaglei.model;

import java.util.List;

/**
 * @author Daniela Bourges-Waldegg
 *
 */
public interface EIInstanceFactory {

	/**
	 * Serialize an EInstance into an RDF language
	 * 
	 * @param instance
	 * @param lang
	 *            - one of the RDF languages supported by Jena; predefined values are "RDF/XML", "RDF/XML-ABBREV", "N-TRIPLE", "TURTLE", (and "TTL") and "N3". The default value, represented by null is "RDF/XML".
	 * @return - the serialized EIInstance as a STring
	 */

	public String serialize(final EIInstance instance, final String lang);

	/**
	 * Create an EIInstance from an RDF String serialization in one of the RDF languages supported by Jena
	 * 
	 * @param instanceUri
	 *            - the instance uri (all the triples in the rdf parameter should have it as subject)
	 * @param rdf
	 * @param lang
	 * @return
	 */

	public  EIInstance create(final EIURI instanceUri, final String rdf, final String lang);

	/**
	 * Create an embedded EIInstance from an RDF String serialization in one of the RDF languages supported by Jena
	 * 
	 * @param instanceUri
	 *            - the instance uri (all the triples in the rdf parameter should have it as subject)
	 * @param rdf
	 * @param lang
	 * @return
	 */

	public  EIInstance createEmbedded(final EIURI instanceUri, final String rdf, final String lang);

	/**
	 * Create an extended EIInstance from an RDF String serialization in one of the RDF languages supported by Jena
	 * 
	 * @param instanceUri
	 *            - the instance uri (all the triples in the rdf parameter should have it as subject)
	 * @param rdf
	 * @param lang
	 * @return
	 */

	public  EIInstance createExtended(final EIURI instanceUri, final String rdf, final String lang);

	/**
	 * Create an EIInstance with no properties other than an eiType (at least one type must be set)
	 * 
	 * @param typeUri
	 *            - type of the EInstance; if more than one, add can be used
	 * @param instanceEntity
	 *            - entity containing the instance Uri and its label
	 * @return null if the typeUri is not an EI Class
	 */
	public EIInstance createEmpty(final EIURI typeUri, final EIEntity instanceEntity);

}