package org.eaglei.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
/**
 * readOnly container associated with EIInstance. To be populated with data from the eagle-i repository
 * @author Daniela Bourges-Waldegg
 *
 */
public class ReferencingResources implements Serializable{

	private static final long serialVersionUID = 1L;
	
	private List<EIInstanceMinimal> referencedByList = new ArrayList<EIInstanceMinimal>();
	//TODO is it a list or a set?
	private Map<EIEntity, List<EIInstanceMinimal>>  materializedInverseProperties = new HashMap<EIEntity, List<EIInstanceMinimal>>();

	public List<EIInstanceMinimal> getReferencedByList() {
		return referencedByList;
	}

	public void setReferencedByList(List<EIInstanceMinimal> allReferencingResources) {
		this.referencedByList = allReferencingResources;
	}

	public Map<EIEntity, List<EIInstanceMinimal>> getMaterializedInverseProperties() {
		return materializedInverseProperties;
	}
	
	public void addMaterializedInverseProperty(final EIEntity property, final EIInstanceMinimal value) {
		List<EIInstanceMinimal> pValues = materializedInverseProperties.get( property );
		if ( pValues == null ) {
			pValues = new ArrayList<EIInstanceMinimal>();
			pValues.add( value );
			materializedInverseProperties.put( property, pValues );
		} else {
			//only add if URI doesn't already exist
			boolean uriInList = false;
			for(EIInstanceMinimal ei : pValues) {
				if(ei.getInstanceURI().equals( value.getInstanceURI() )) {
					uriInList = true;
					break;
				}
			}
			if(!uriInList) {
				pValues.add( value );
			}
		}
			
	}

	public List<EIInstanceMinimal> getMaterializedInverseProperty(final EIEntity property) {
		return materializedInverseProperties.get( property );
	}


	public void replaceMaterializedInverseProperty(final EIEntity property, final List<EIInstanceMinimal> values) {
		materializedInverseProperties.put( property, values );
	}
}
