package org.eaglei.model;

import java.io.Serializable;

/**
 * A very simple representation of the restriction constructs
 * we currently support.
 * 
 * HAS_VALUE binds the property value to a specific individual
 * ALL_VALUES indicates that the values must come from the given class
 * SOME_VALUES indicates that there must be at least one of the class
 */
public class EIValueRestriction implements Serializable {

    public enum Type { HAS_VALUE, ALL_VALUES, SOME_VALUES };
    
    private Type type;
	private String uri;
	private EIClass eiClass;
	
	private EIValueRestriction() {
		// for gwt
	}
    
    public EIValueRestriction(Type type, String uri, EIClass eiClass) {
    	this.type = type;
    	this.uri = uri;
    	this.eiClass = eiClass;
    }

    public Type getType() {
		return type;
	}

    public String getURI() {
        return uri;
    }

    public EIClass getEIClass() {
        return eiClass;
    }

}
