/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model;

import java.util.Map;
import java.util.Set;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

public class SearchEIInstancePreview {
    private int propertyCount;
    private final EIInstance actualInstance;

    public SearchEIInstancePreview(EIInstance basicInstance) {
        this.actualInstance = basicInstance;
        this.propertyCount = 0;
        this.countProperties(basicInstance);
    }

    private void countProperties(EIInstance basicInstance) {
        Map<EIEntity, Set<String>> datatypeProps = basicInstance.getDatatypeProperties();
        for (EIEntity key : datatypeProps.keySet()) {
            this.propertyCount += datatypeProps.get(key).size();
        }
        Map<EIEntity, Set<EIEntity>> objectProps = basicInstance.getObjectProperties();
        for (EIEntity key : objectProps.keySet()) {
            this.propertyCount += objectProps.get(key).size();
        }
    }

    public EIEntity getEntity() {
        return this.actualInstance.getEntity();
    }

    public int getPropertyCount() {
        return this.propertyCount;
    }

    public EIURI getInstanceURI() {
        return this.actualInstance.getInstanceURI();
    }

    public String getInstanceLabel() {
        return this.actualInstance.getInstanceLabel();
    }

    public EIEntity getInstanceType() {
        return this.actualInstance.getInstanceType();
    }

    public EIInstance getRealInstance() {
        return this.actualInstance;
    }
}

