package org.eaglei.model;

/**
 * Holds eagle-i ontology constants
 */
public final class EIOntConstants {

    /**
     * Namespace of eagle-i-app-ont.owl ontology.
     * Used for eagle-i class/property annotation definitions.
     */
    public static final String EAGLE_I_APP_ONT_URI = "http://eagle-i.org/ont/app/1.0/";
    
    /**
     * URI of the eagle-i.owl ontology
     */
    public static final String EAGLE_I_URI = "http://purl.obolibrary.org/obo/";
    
    /**
     * URI of the eagle-i model root
     */
    public static final String EAGLE_I_APP_EXT_URI = "http://purl.org/eagle-i/app-ext/";

    /**
     * URI of the OBI definition annotation property
     */
    public static final String OBI_DEFINITION_URI = "http://purl.obolibrary.org/obo/IAO_0000115";

    /**
     * URI of the IAO perferred term annotation property
     */
    public static final String IAO_PREFERRED_TERM_URI = "http://purl.obolibrary.org/obo/IAO_0000111";
    
    /**
     * URI of the IAO alternate term annotation property
     */
    public static final String IAO_ALTERNATE_TERM_URI = "http://purl.obolibrary.org/obo/IAO_0000118";
        
    /**
     * URI of the eagle-i preferred definition annotation property
     */
    public static final String EI_PREFERRED_DEFINITION_URI = EAGLE_I_APP_ONT_URI + "preferredDefinition";

    /**
     * URI of annotation property that is used to specify eagle-i specific preferred labels
     */
    public static final String EI_PREFERRED_LABEL = EAGLE_I_APP_ONT_URI + "preferredLabel";    
    
    /**
     * URI of annotation property that is used to specify a list of domain URIs that
     * should take precedence over the domain specification in the ontoloyg model.
     */
    public static final String DOMAIN_CONSTRAINT = EAGLE_I_APP_ONT_URI + "domainConstraint";    
    
    /**
     * URI of annotation property that is used to specify a list of range URIs that
     * should take precedence over the range list in the ontology model.
     */
    public static final String RANGE_CONSTRAINT = EAGLE_I_APP_ONT_URI + "rangeConstraint";    
    
    /**
     * URI of the annotation property used to mark class group.
     */
    public static final String IN_CLASS_GROUP = EAGLE_I_APP_ONT_URI + "inClassGroup";
    
    /**
     * URI of the annotation property used to mark property group.
     */
    public static final String IN_PROPERTY_GROUP = EAGLE_I_APP_ONT_URI + "inPropertyGroup";
    
    /**
     * Value of IN_CLASS_GROUP annotation that indicates a root of an eagle-i resource type hierarchy.
     * Eagle-i creates instance data for classes in this type hierarchy.
     */
    public static final String CG_RESOURCE_ROOT = EAGLE_I_APP_ONT_URI + "ClassGroup/resourceRoot";
    
    /**
     * Value of IN_CLASS_GROUP annotation that indicates a root of an eagle-i non-resource type hierarchy.
     * Eagle-i does not create instance data for classes in this type hierarchy.  Class URIs are used
     * as object property values only.
     */
    public static final String CG_NON_RESOURCE_ROOT = EAGLE_I_APP_ONT_URI + "ClassGroup_NonResourceRoot";
    
    /**
     * Value of IN_CLASS_GROUP annotation that indicates a root of a type hierarchy for which all instances
     * of these types will be referenced by one and only instance.
     */
    public static final String CG_EMBEDDED_CLASS = EAGLE_I_APP_ONT_URI + "ClassGroup_embedded_class";
    
    /**
     * Value of IN_CLASS_GROUP annotation that indicates a root of a type hierarchy for which all instance
     * data for these types should be indexed by the search engine as part of the referencing instance.
     */
    public static final String CG_SEARCH_FLATTEN = EAGLE_I_APP_ONT_URI + "ClassGroup_SearchFlatten";
    
    /**
     * Value of IN_CLASS_GROUP annotation that indicates this class should not be allowed as the asserted
     * type of an eagle-i resource instance.
     * This annotation is used to flag equivalent classes that appear in the inferred model as a subtype of
     * a resource root class.
     */
    public static final String CG_NO_ASSERTED_INSTANCES = EAGLE_I_APP_ONT_URI + "ClassGroup_no_asserted_instances";    
    
    /**
     * Value of IN_PROPERTY_GROUP annotation that indicates properties that should be exposed for data collection.
     */
    public static final String PG_DATA_MODEL_EXCLUDE = EAGLE_I_APP_ONT_URI + "PropertyGroup/dataModelExclude";
    
    /**
     * Value of IN_PROPERTY_GROUP annotation that indicates properties that should be used
     * as search filters.
     */
    //public static final String PG_SEARCH_FILTER = EAGLE_I_APP_ONT_URI + "PropertyGroup/searchFilter";

    /**
     * Value of IN_PROPERTY_GROUP annotation that indicates properties that 
     * hold administrative data. These properties should not be indexed for search or
     * exposed in non-admin UIs.
     */
    public static final String PG_ADMIN_DATA_GROUP = EAGLE_I_APP_ONT_URI + "PropertyGroup/adminData";    
   
    /**
     * Properties that identify relationship with a lab
     */
    public static final String PG_LAB_RELATED = EAGLE_I_APP_ONT_URI + "PropertyGroup/relatedLab"; 
    
    /**
     * Properties that identify a resource provider
     */
    public static final String PG_RELATED_RESOURCE_PROVIDER = EAGLE_I_APP_ONT_URI + "PropertyGroup_RelatedResourceProvider"; 
    
    /**
     * Value used to identify properties that must be hidden by default when hiding mode is engaged
     */
    public static final String PG_CONTACT_LOCATION = EAGLE_I_APP_ONT_URI + "PropertyGroup_ContactLocation";
    
    /**
     * Properties in this group name an email contact address for the subject, e.g. a person's email address
     */
    public static final String PG_EMAIL_CONTACT = EAGLE_I_APP_ONT_URI + "PropertyGroup_EmailContact";
    
    /**
     * Properties in this group are considered essential properties of a resource (should appear first in forms, after common fields)
     * 
     */
    public static final String PG_PRIMARY = EAGLE_I_APP_ONT_URI + "PropertyGroup_PrimaryProperties";
    
    /**
     * Properties in this group are considered secondary properties of a resource (should appear second in forms, after common fields)
     * 
     */
    public static final String PG_SECONDARY = EAGLE_I_APP_ONT_URI + "PropertyGroup_SecondaryProperties";

    /**
     * Properties in this group are considered secondary properties of a resource (should appear second in forms, after common fields)
     * 
     */
    public static final String PG_TERTIARY = EAGLE_I_APP_ONT_URI + "PropertyGroup_TertiaryProperties";
   
    
    /**
     * URI for property that is used to record the direct rdf:type of a resource when the type 
     * hierarchy is being materialized.
     */
    public static final String DIRECT_TYPE_URI = EIOntConstants.EAGLE_I_URI + "directType";

    /**
     * URI for the located_in object property
     */
    public static final String LOCATED_IN_URI = "http://www.obofoundry.org/ro/ro.owl#located_in";

    /**
     * URI for the location_of object property
     */
    public static final String LOCATION_OF_URI = "http://www.obofoundry.org/ro/ro.owl#location_of";
    
    /**
     * URI for the used_by object property
     */
    public static final String USED_BY_URI = "http://purl.obolibrary.org/obo/ERO_0000070";

    /**
     * URI for the service_provided_by property
     */
    public static final String SERVICE_PROVIDED_BY_URI = "http://purl.obolibrary.org/obo/ERO_0000390";
    
    /**
     * special :isDeleted predicate
     */
    public static final String IS_DELETED = "http://eagle-i.org/ont/repo/1.0/isDeleted";       
    
    public static final String EI_LAB = "http://purl.obolibrary.org/obo/ERO_0000001";

    public static final String EI_ORGANIZATION = "http://purl.obolibrary.org/obo/OBI_0000245";
    
    public static final String URL_PROPERTY_URI = "http://purl.obolibrary.org/obo/ERO_0000480";
    
    /**
     * Value of IN_CLASS_GROUP annotation that indicates instances of this class can be directly created 
     * (as opposed to being created as a secondary instance, either linked or embedded)
     * 
     */
    public static final String CG_DATA_MODEL_CREATE = EAGLE_I_APP_ONT_URI + "ClassGroup_DataModelCreate";
    
    /**
     * Value of IN_CLASS_GROUP annotation that indicates instances of this class can provide resources (serve as location,
     * etc)
     */
    public static final String CG_RESOURCE_PROVIDER = EAGLE_I_APP_ONT_URI + "ClassGroup_ResourceProvider";
     
}