package org.eaglei.model;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;


public class SearchEIInstancePreview implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -836466111343717562L;
	private EIInstance actualInstance;
	
	public SearchEIInstancePreview() {
		// For GWT
	}
	
	public SearchEIInstancePreview(final EIInstance basicInstance) {
		actualInstance = basicInstance;
		
		countProperties( basicInstance );
	}

	private int countProperties(final EIInstance basicInstance) {
		int propertyCount = 0;
		Map<EIEntity, Set<String>> datatypeProps = basicInstance.getDatatypeProperties();
		for ( EIEntity key : datatypeProps.keySet() ) {
			propertyCount += datatypeProps.get( key ).size();
		}
		
		Map<EIEntity, Set<EIEntity>> objectProps = basicInstance.getObjectProperties();
		for ( EIEntity key : objectProps.keySet() ) {
			propertyCount += objectProps.get( key ).size();
		}
		return propertyCount;
	}

	public EIEntity getEntity() {
		return actualInstance.getEntity();
	}

	public int getPropertyCount() {
		return countProperties(actualInstance);
	}
	
	public EIURI getInstanceURI() {
		return actualInstance.getInstanceURI();
	}

	public String getInstanceLabel() {
		return actualInstance.getInstanceLabel();
	}

	public EIEntity getInstanceType() {
		return actualInstance.getInstanceType();
	}

	public EIInstance getRealInstance() {
		return actualInstance;
	}
}
