/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIInstance;
import org.eaglei.model.EIURI;

public class SearchEIInstancePreview
implements Serializable {
    private static final long serialVersionUID = -836466111343717562L;
    private EIInstance actualInstance;

    public SearchEIInstancePreview() {
    }

    public SearchEIInstancePreview(EIInstance basicInstance) {
        this.actualInstance = basicInstance;
        this.countProperties(basicInstance);
    }

    private int countProperties(EIInstance basicInstance) {
        int propertyCount = 0;
        Map<EIEntity, Set<String>> datatypeProps = basicInstance.getDatatypeProperties();
        for (EIEntity key : datatypeProps.keySet()) {
            propertyCount += datatypeProps.get(key).size();
        }
        Map<EIEntity, Set<EIEntity>> objectProps = basicInstance.getObjectProperties();
        for (EIEntity key : objectProps.keySet()) {
            propertyCount += objectProps.get(key).size();
        }
        return propertyCount;
    }

    public EIEntity getEntity() {
        return this.actualInstance.getEntity();
    }

    public int getPropertyCount() {
        return this.countProperties(this.actualInstance);
    }

    public EIURI getInstanceURI() {
        return this.actualInstance.getInstanceURI();
    }

    public String getInstanceLabel() {
        return this.actualInstance.getInstanceLabel();
    }

    public EIEntity getInstanceType() {
        return this.actualInstance.getInstanceType();
    }

    public EIInstance getRealInstance() {
        return this.actualInstance;
    }
}

