/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIClass;
import org.eaglei.model.EIDatatypeProperty;
import org.eaglei.model.EIEntity;
import org.eaglei.model.EIObjectProperty;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.EIOntResource;
import org.eaglei.model.EIProperty;
import org.eaglei.model.EIURI;
import org.eaglei.model.jena.JenaEIOntModel;

public class AcceptanceCheckVisitor
implements EIOntModel.Visitor {
    protected static final Log logger = LogFactory.getLog(AcceptanceCheckVisitor.class);
    private JenaEIOntModel model;
    public ArrayList<Item> listMessages = new ArrayList();
    public ArrayList<Item> listInfos = new ArrayList();
    public ArrayList<Item> listWarnings = new ArrayList();
    public ArrayList<Item> listErrors = new ArrayList();
    public int count;
    public int numProperties = 0;
    public int numClassesWithAltLabels = 0;
    public HashSet<EIURI> setCheckedProperties = new HashSet();

    public AcceptanceCheckVisitor(EIOntModel model) {
        this.model = (JenaEIOntModel)model;
        this.count = 0;
    }

    public String traversalComplete() {
        logger.info((Object)"Ontology acceptance checker completed scan");
        logger.info((Object)("Number of classes checked: " + this.count));
        logger.info((Object)("Number of classes with synonyms: " + this.numClassesWithAltLabels));
        logger.info((Object)("Number of properties checked: " + this.numProperties));
        StringBuilder buf = null;
        if (this.listErrors.size() > 0) {
            buf = new StringBuilder();
            buf.append("ontology scan found " + this.listErrors.size() + " errors\n");
            for (Item error : this.listErrors) {
                buf.append(error.uri + " : " + error.label + " : " + error.msg + "\n");
            }
        }
        return buf != null ? buf.toString() : null;
    }

    public void visit(EIClass c, Deque<String> stack) {
        List labels;
        String def;
        if (this.count % 20 == 0) {
            logger.info((Object)(this.count + " classes have been checked.  Errors: " + this.listErrors.size() + "  Warnings: " + this.listWarnings.size()));
        }
        ++this.count;
        if ("<no_label>".equals(c.getEntity().getLabel())) {
            this.addError((EIOntResource)c, stack, "Class has no label.");
        }
        if (!c.isEagleIResource()) {
            for (EIClass top : this.model.getTopLevelClasses()) {
                if (!this.model.isSubClass(c.getEntity().getURI(), top.getEntity().getURI())) continue;
                this.addError((EIOntResource)c, stack, "Class is a superclass of the rootResource " + top.getEntity());
                break;
            }
        }
        if ((def = this.model.getClassDefinition(c.getEntity().getURI())) == null) {
            this.addWarning(c.getEntity(), "Class has no definition");
        }
        if ((labels = this.model.getLabels(c.getEntity().getURI())).size() > 1) {
            ++this.numClassesWithAltLabels;
        }
    }

    public void visit(EIProperty p, Deque<String> stack) {
        if (this.setCheckedProperties.contains(p.getEntity().getURI())) {
            return;
        }
        this.setCheckedProperties.add(p.getEntity().getURI());
        if ("<no_label>".equals(p.getEntity().getLabel())) {
            this.addError((EIOntResource)p, stack, "Property has no label.");
        }
        if (p instanceof EIDatatypeProperty) {
            if (((EIDatatypeProperty)p).getTypeLabel() == null) {
                this.addWarning(p.getEntity(), "Datatype property has unknown range");
            }
        } else if (((EIObjectProperty)p).getRangeList() == null || ((EIObjectProperty)p).getRangeList().size() == 0) {
            this.addError((EIOntResource)p, stack, "Object property has unknown range");
        }
        ++this.numProperties;
    }

    private void addInfo(EIEntity e, String msg) {
        Item item = new Item(Levels.INFO, e.getURI().toString(), e.getLabel(), msg);
        this.listMessages.add(item);
        this.listInfos.add(item);
    }

    private void addWarning(EIEntity e, String msg) {
        Item item = new Item(Levels.WARNING, e.getURI().toString(), e.getLabel(), msg);
        this.listMessages.add(item);
        this.listWarnings.add(item);
    }

    private void addError(EIOntResource r, Deque<String> stack, String msg) {
        String stackMsg = this.model.generateStackTrace(stack);
        String msgWithStack = msg + "\r\n" + stackMsg;
        Item item = new Item(Levels.ERROR, r.getEntity().getURI().toString(), r.getEntity().getLabel(), msgWithStack);
        this.listMessages.add(item);
        this.listErrors.add(item);
    }

    public static class Item {
        public Levels level;
        public String uri;
        public String label;
        public String msg;

        Item(Levels level, String uri, String label, String msg) {
            this.level = level;
            this.uri = uri;
            this.label = label;
            this.msg = msg;
        }
    }

    private static enum Levels {
        INFO,
        WARNING,
        ERROR;

    }
}

