/*
 * Decompiled with CFR 0.152.
 */
package org.eaglei.model.jena;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eaglei.model.EIOntModel;
import org.eaglei.model.jena.AcceptanceCheckVisitor;
import org.eaglei.model.jena.NonResourceVisitor;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class OntologyAcceptanceCheck
extends TestCase {
    private static final Log logger = LogFactory.getLog(OntologyAcceptanceCheck.class);
    private EIOntModel eagleiOntModel;

    protected void setUp() throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"jena-model-config.xml"});
        this.eagleiOntModel = (EIOntModel)context.getBean(EIOntModel.class);
    }

    public void testDataModelTraversal() {
        ArrayList<Object> visitors = new ArrayList<Object>();
        AcceptanceCheckVisitor log = new AcceptanceCheckVisitor(this.eagleiOntModel);
        visitors.add(log);
        NonResourceVisitor nonres = new NonResourceVisitor(this.eagleiOntModel);
        visitors.add(nonres);
        this.eagleiOntModel.traverseDataModel(visitors);
        String errorMsg = nonres.traversalComplete();
        if (errorMsg != null) {
            OntologyAcceptanceCheck.fail((String)errorMsg);
        } else {
            logger.info((Object)"No errors in non-resource class list generation.");
        }
        errorMsg = log.traversalComplete();
        if (errorMsg != null) {
            OntologyAcceptanceCheck.fail((String)errorMsg);
        } else {
            logger.info((Object)"No errors in the owl acceptance test.");
        }
    }
}

