/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDatatype;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.ContinuousRealInterval;
import com.clarkparsia.pellet.datatypes.types.real.IntegerInterval;
import com.clarkparsia.pellet.datatypes.types.real.OWLReal;
import com.clarkparsia.pellet.datatypes.types.real.RestrictedRealDatatype;
import java.math.BigDecimal;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.mindswap.pellet.utils.ATermUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDDecimal
extends AbstractBaseDatatype<Number> {
    private static final XSDDecimal instance;
    private static final Logger log;
    private final RestrictedRealDatatype dataRange = new RestrictedRealDatatype(this, IntegerInterval.allIntegers(), ContinuousRealInterval.allReals(), null);

    public static XSDDecimal getInstance() {
        return instance;
    }

    private XSDDecimal() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#decimal"));
    }

    @Override
    public RestrictedDatatype<Number> asDataRange() {
        return this.dataRange;
    }

    @Override
    public ATermAppl getCanonicalRepresentation(ATermAppl input) throws InvalidLiteralException {
        String lexicalForm = this.getLexicalForm(input);
        try {
            BigDecimal d = DatatypeConverter.parseDecimal((String)lexicalForm);
            String canonicalForm = DatatypeConverter.printDecimal((BigDecimal)d);
            if (canonicalForm.equals(lexicalForm)) {
                return input;
            }
            return ATermUtils.makeTypedLiteral(canonicalForm, this.getName());
        }
        catch (NumberFormatException e2) {
            log.severe(String.format("Number format exception (%s) cause while parsing decimal %s", e2.getMessage(), lexicalForm));
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }

    @Override
    public ATermAppl getLiteral(Object value) {
        if (this.dataRange.contains(value)) {
            return ATermUtils.makeTypedLiteral(OWLRealUtils.print((Number)value), this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return OWLReal.getInstance();
    }

    @Override
    public Number getValue(ATermAppl literal) throws InvalidLiteralException {
        String lexicalForm = this.getLexicalForm(literal);
        try {
            return OWLRealUtils.getCanonicalObject(DatatypeConverter.parseDecimal((String)lexicalForm));
        }
        catch (NumberFormatException e2) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    static {
        log = Logger.getLogger(XSDDecimal.class.getCanonicalName());
        instance = new XSDDecimal();
    }
}

