/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import java.math.BigInteger;
import javax.xml.bind.DatatypeConverter;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDPositiveInteger
extends AbstractDerivedIntegerType {
    private static final XSDPositiveInteger instance = new XSDPositiveInteger();

    public static XSDPositiveInteger getInstance() {
        return instance;
    }

    private XSDPositiveInteger() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#positiveInteger"), 1, null);
    }

    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            BigInteger n = DatatypeConverter.parseInteger((String)lexicalForm);
            if (BigInteger.ZERO.compareTo(n) >= 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return n;
        }
        catch (NumberFormatException e2) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }
}

