/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomObject;
import com.clarkparsia.pellet.rules.model.AtomObjectVisitor;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.RuleAtomVisitor;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import org.mindswap.pellet.utils.ATermUtils;

public class RulesToATermTranslator
implements RuleAtomVisitor,
AtomObjectVisitor {
    private ATermAppl term;

    public ATermAppl translate(Rule rule) {
        this.term = null;
        this.visit(rule);
        return this.term;
    }

    public ATermAppl translate(RuleAtom ruleAtom) {
        this.term = null;
        ruleAtom.accept(this);
        return this.term;
    }

    public ATermAppl translate(AtomObject obj) {
        this.term = null;
        obj.accept(this);
        return this.term;
    }

    public void visit(Rule rule) {
        ATermAppl[] head = new ATermAppl[rule.getHead().size()];
        ATermAppl[] body = new ATermAppl[rule.getBody().size()];
        int i = 0;
        for (RuleAtom ruleAtom : rule.getHead()) {
            head[i++] = this.translate(ruleAtom);
        }
        i = 0;
        for (RuleAtom ruleAtom : rule.getBody()) {
            body[i++] = this.translate(ruleAtom);
        }
        this.term = ATermUtils.makeRule(rule.getName(), head, body);
    }

    public void visit(BuiltInAtom atom) {
        int arity = atom.getAllArguments().size();
        ATermAppl[] args = new ATermAppl[arity + 1];
        args[0] = ATermUtils.makeTermAppl((String)atom.getPredicate());
        int i = 1;
        for (AtomDObject arg : atom.getAllArguments()) {
            args[i++] = this.translate(arg);
        }
        this.term = ATermUtils.makeBuiltinAtom(args);
    }

    public void visit(ClassAtom atom) {
        ATermAppl c = (ATermAppl)atom.getPredicate();
        ATermAppl i = this.translate((AtomObject)atom.getArgument());
        this.term = ATermUtils.makeTypeAtom(i, c);
    }

    public void visit(DataRangeAtom atom) {
        ATermAppl d = (ATermAppl)atom.getPredicate();
        ATermAppl l = this.translate((AtomObject)atom.getArgument());
        this.term = ATermUtils.makeTypeAtom(l, d);
    }

    public void visit(DatavaluedPropertyAtom atom) {
        ATermAppl p = (ATermAppl)atom.getPredicate();
        ATermAppl s = this.translate((AtomObject)atom.getArgument1());
        ATermAppl o = this.translate((AtomObject)atom.getArgument2());
        this.term = ATermUtils.makePropAtom(p, s, o);
    }

    public void visit(DifferentIndividualsAtom atom) {
        ATermAppl t1 = this.translate((AtomObject)atom.getArgument1());
        ATermAppl t2 = this.translate((AtomObject)atom.getArgument2());
        this.term = ATermUtils.makeDifferent(t1, t2);
    }

    public void visit(IndividualPropertyAtom atom) {
        ATermAppl p = (ATermAppl)atom.getPredicate();
        ATermAppl s = this.translate((AtomObject)atom.getArgument1());
        ATermAppl o = this.translate((AtomObject)atom.getArgument2());
        this.term = ATermUtils.makePropAtom(p, s, o);
    }

    public void visit(SameIndividualAtom atom) {
        ATermAppl t1 = this.translate((AtomObject)atom.getArgument1());
        ATermAppl t2 = this.translate((AtomObject)atom.getArgument2());
        this.term = ATermUtils.makeSameAs(t1, t2);
    }

    public void visit(AtomDConstant constant) {
        this.term = constant.getValue();
    }

    public void visit(AtomDVariable variable) {
        this.term = ATermUtils.makeVar(variable.getName());
    }

    public void visit(AtomIConstant constant) {
        this.term = constant.getValue();
    }

    public void visit(AtomIVariable variable) {
        this.term = ATermUtils.makeVar(variable.getName());
    }
}

