/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

final class StringUnmarshaller {
    StringUnmarshaller() {
    }

    static String unmarshall(String str2) {
        str2 = str2.substring(1, str2.length() - 1);
        int len = str2.length();
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            char c = str2.charAt(i);
            ++i;
            if (c == '\\') {
                char c1 = str2.charAt(i);
                ++i;
                if (c1 == 'u') {
                    int codePoint = StringUnmarshaller.getCodePoint(str2, i);
                    sb.appendCodePoint(codePoint);
                    i += 4;
                    continue;
                }
                char escapedChar = StringUnmarshaller.getEscapedChar(str2, c1);
                sb.append(escapedChar);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static int getCodePoint(String str2, int i) {
        String s = str2.substring(i, i + 4);
        int codePoint = Integer.parseInt(s, 16);
        return codePoint;
    }

    private static char getEscapedChar(String str2, char c) {
        char ch;
        switch (c) {
            case 'n': {
                ch = '\n';
                break;
            }
            case 'b': {
                ch = '\b';
                break;
            }
            case 'f': {
                ch = '\f';
                break;
            }
            case 't': {
                ch = '\t';
                break;
            }
            case 'r': {
                ch = '\r';
                break;
            }
            case '\"': {
                ch = '\"';
                break;
            }
            case '\'': {
                ch = '\'';
                break;
            }
            case '\\': {
                ch = '\\';
                break;
            }
            case '/': {
                ch = '/';
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected character: " + c + " in " + str2);
            }
        }
        return ch;
    }
}

